% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_kinetic_dataset.R
\name{create_kinetic_dataset}
\alias{create_kinetic_dataset}
\title{Create kinetics dataset for a list of peptides and their states}
\usage{
create_kinetic_dataset(
  dat,
  peptide_list,
  protein = dat[["Protein"]][1],
  time_0 = min(dat[["Exposure"]]),
  time_100 = max(dat[["Exposure"]]),
  deut_part = 0.9
)
}
\arguments{
\item{dat}{dat data imported by the \code{\link{read_hdx}} function.}

\item{peptide_list}{list of peptides for the calculation.}

\item{protein}{chosen protein.}

\item{time_0}{minimal exchange control time point of measurement.}

\item{time_100}{maximal exchange control time point of measurement.}

\item{deut_part}{deuterium percentage in solution used in experiment, 
value from range [0, 1].}
}
\value{
a \code{\link{data.frame}} object.
}
\description{
Generates the data set of deuterium uptake between selected 
time points based on supplied peptide list.
}
\details{
This is a wrapper for \code{\link{calculate_kinetics}}, but for
the peptide list instead of one peptide.
}
\examples{
peptide_list <- data.frame(Sequence = c("GFGDLKSPAGL", "FGDLKSPAGL"), 
                           state = c("ALPHA_Gamma", "ALPHA_Gamma"), 
                           start = c(1, 2), end = c(11, 11))
create_kinetic_dataset(alpha_dat, peptide_list)

}
\seealso{
\code{\link{calculate_kinetics}}
\code{\link{calculate_state_uptake}}
\code{\link{plot_uptake_curve}}
}
