% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/std.R
\name{std}
\alias{std}
\title{Standardizes a Design Matrix}
\usage{
std(X, tol = 1e-06)
}
\arguments{
\item{X}{Design matrix, of dimension \code{nobs} by \code{nvars}; each row is an observation vector; 
can also be an object that can be coerced to a matrix, e.g. a data.frame.}

\item{tol}{The tolerance value; a column of \code{X} is considered as singular if the \code{sd}
of its entries (observations) is less than \code{tol}. Singular columns will be dropped by the end.}
}
\value{
The standardized design matrix with the following attributes:
\describe{
  \item{nonsingular}{Indices of non-singular columns.}
  \item{center}{Median of each non-singular column which is used for standardization.}
  \item{scale}{Standard deviation of each non-singular column which is used for standardization.}
}
}
\description{
This function accepts a design matrix and returns a standardized version of that matrix, 
the statistics of each column such as \code{median} and \code{sd} are also provided.
}
\details{
For each column of \code{X}, the standardization is done by first subtracting its median, 
then dividing by its sample standard deviation, while the original version in \code{ncvreg} uses
mean and population standard deviation. Its speed is slower than \code{ncvreg} because of the
complexity of median finding, but still substantially faster than \code{scale()} provided by R base.
}
\examples{
set.seed(123)
mat <- matrix(rnorm(n = 80 * 90, mean = 100, sd = 50), 80, 90)
mat \%>\% as.numeric() \%>\% ggplot2::qplot(bins = 30, xlab = '')
mat \%>\% std() \%>\% as.numeric() \%>\% ggplot2::qplot(bins = 30, xlab = '')
 
}
\seealso{
\url{http://pbreheny.github.io/ncvreg/reference/std.html}
}
\author{
Patrick Breheny (original) \cr Steven Liu (modification)
}
