% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_population.R
\name{set_population}
\alias{set_population}
\title{Set population data}
\usage{
set_population(x, age = NULL, obesity = NULL)
}
\arguments{
\item{x}{GeoTox object.}

\item{age}{numeric vector or list of numeric vectors of age values.}

\item{obesity}{character vector or list of character vectors of obesity
status.}
}
\value{
The same object with simulated fields added.
}
\description{
Set population data
}
\examples{
# Single region
age <- round(runif(10, 1, 100))
obesity <- sample(c("Normal", "Obese"), 10, replace = TRUE)
geoTox <- set_population(GeoTox(), age = age, obesity = obesity)

# Multiple regions
age <- list("37001" = round(runif(10, 1, 100)),
            "37007" = round(runif(8, 1, 100)))
obesity <- list("37001" = sample(c("Normal", "Obese"), 10, replace = TRUE),
                "37007" = sample(c("Normal", "Obese"), 8, replace = TRUE))
geoTox <- set_population(GeoTox(), age = age, obesity = obesity)
}
