% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flex_manhattan.R
\name{flex_manhattan}
\alias{flex_manhattan}
\title{flex_manhattan function}
\usage{
flex_manhattan(
  gwas_data,
  interactive = TRUE,
  user_colors = NULL,
  user_y_cutoff = -log10(5e-08),
  user_y_cutoff_color = "red",
  user_title = "Manhattan Plot",
  user_x_title = "Position",
  user_y_title = "-log10(p-value)",
  user_legend_title = "Chromosome",
  user_plot_theme = theme_minimal(),
  user_plot_theme_specs = theme(legend.title = element_text(size = 10), legend.text =
    element_text(size = 10), title = element_text(size = 15), axis.text.x =
    element_text(size = 10), axis.title.x = element_text(size = 10), axis.text.y =
    element_text(size = 10), axis.title.y = element_text(size = 10)),
  annotate_data = NULL,
  annotate_column = "SNP",
  annotate_labels = FALSE,
  zoom_on_annotations = FALSE,
  zoom_margin = 1,
  ...
)
}
\arguments{
\item{gwas_data}{A data frame containing columns for SNP ID ('SNP'), chromosome ('CHR'),
position ('POS'), and p-values ('P_VALUE').}

\item{interactive}{Logical; if TRUE, returns an interactive plotly plot, otherwise
a ggplot2 plot.}

\item{user_colors}{A vector of colors for the chromosomes. If NULL, a default set
of 22 colors is used.}

\item{user_y_cutoff}{A numeric value for the y-axis cutoff, used to draw a horizontal line.}

\item{user_y_cutoff_color}{Color of the y-axis cutoff line.}

\item{user_title}{The main title of the plot.}

\item{user_x_title}{The label for the x-axis.}

\item{user_y_title}{The label for the y-axis.}

\item{user_legend_title}{The title for the legend. If NULL, no legend is displayed.}

\item{user_plot_theme}{ggplot2 theme object for styling the plot background and fonts.}

\item{user_plot_theme_specs}{Additional ggplot2 theme specifications for custom styling.}

\item{annotate_data}{A vector of SNP identifiers for which annotations are to be made.}

\item{annotate_column}{The column name from \code{gwas_data} used for matching \code{annotate_data}.}

\item{annotate_labels}{Logical; if TRUE, annotations are added to the plot.}

\item{zoom_on_annotations}{Logical; if TRUE, the plot will zoom in on annotated SNPs.}

\item{zoom_margin}{Numeric; defines the margin around the zoomed area as a proportion
of the range of the data.}

\item{...}{Additional arguments to be passed to ggplot2 plotting functions.}
}
\value{
An object of class 'ggplot' or 'plotly' depending on the 'interactive' parameter.
}
\description{
This function creates a flexible Manhattan plot, which is useful for visualizing
GWAS results.
The plot can be generated as either a static or an interactive plot. The function allows
customization of color schemes, titles, axis labels, and annotation features.
}
\examples{
library(ggplot2)
library(plotly)
library(dplyr)
library(nortest)
library(ggforce)
library(reshape2)
library(gridExtra)
library(grid)
library(cowplot)
flex_manhattan(example_data1)

# Changing the y-axis cutoff to highlight significant p-values differently
flex_manhattan(example_data1, 
               user_y_cutoff = c(5, 4),  # Multiple cutoffs
               user_y_cutoff_color = c("darkred", "darkgreen"))  # Corresponding colors

# Adding annotations for specific SNPs
annotated_snps <- c("SNP_2550", "SNP_4829", "SNP_8296")
flex_manhattan(example_data1, annotate_data = annotated_snps, annotate_labels = TRUE, 
interactive = FALSE)


# Example of placing the legend at the bottom with a black outline
flex_manhattan(example_data1, 
               user_plot_theme_specs = theme(
                 legend.position = "bottom",
                 legend.box.background = element_rect(colour = "black")
               ))
               
}
