

param_random <- function(x, k) {
  
  x <- as.matrix(x)
  storage.mode(x) <- "double"
  
  n <- nrow(x)
  p <- ncol(x)
  
  
  mu_init <- x[sample(1:n, k, replace = FALSE), , drop = FALSE]
  
 
  sigma_init <- array(0, dim = c(p, p, k))
  for (i in 1:k) {
    sigma_init[,, i] <- diag(p) * 1e-6 + diag(p)  
  }
  

  pi_k <- runif(k)
  pi_k <- pi_k / sum(pi_k)
  pi_k <- pmax(pi_k, 1e-3)     
  pi_k <- pi_k / sum(pi_k)
  
 
  return(list(
    pi_k = pi_k,
    mu    = mu_init,
    sigma = sigma_init
  ))
}
