% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glme.gev.R
\name{pk.beta.stnary}
\alias{pk.beta.stnary}
\title{Beta preference function for stationary GEV}
\usage{
pk.beta.stnary(
  para = NULL,
  lme.center = NULL,
  p = NULL,
  q = NULL,
  c0 = 0.3,
  c1 = 10,
  c2 = 5
)
}
\arguments{
\item{para}{A vector of GEV parameters.}

\item{lme.center}{L-moment estimates as center.}

\item{p}{Shape parameter (default 6).}

\item{q}{Shape parameter q (optional, if provided uses fixed limits).}

\item{c0}{Limit parameter (default 0.3).}

\item{c1}{Scaling parameter (default 10).}

\item{c2}{Upper limit parameter (default 5).}
}
\value{
A list containing:
\describe{
  \item{pk.one}{Preference function value (scalar)}
  \item{p}{Shape parameter p used}
  \item{q}{Shape parameter q used}
}
}
\description{
Computes a Beta distribution-based adaptive preference (penalty) function
for the GEV shape parameter. The hyperparameters are adapted based on the
L-moment estimate of the shape parameter.
}
\examples{
# Beta preference for xi = -0.2 centered at LME xi = -0.15
pk.beta.stnary(para = c(100, 20, -0.2),
               lme.center = c(100, 20, -0.15), p = 6)

}
\references{
Shin, Y., Shin, Y., Park, J. & Park, J.-S. (2025). Generalized method of
L-moment estimation for stationary and nonstationary extreme value models.
arXiv preprint arXiv:2512.20385. \doi{10.48550/arXiv.2512.20385}
}
\seealso{
\code{\link{pk.norm.stnary}} for the normal penalty,
  \code{\link{MS_pk}} for the Martins-Stedinger penalty,
  \code{\link{glme.gev}} which uses these penalty functions.
}
\author{
Yonggwan Shin, Seokkap Ko, Jihong Park, Yire Shin, Jeong-Soo Park
}
