% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{cmsc_tw}
\alias{cmsc_tw}
\alias{cmsc_e1_tw}
\alias{cmsc_e2_tw}
\alias{gcsm_tw}
\title{Composite similarity on temporal windows}
\usage{
cmsc_tw(
  xxx,
  yyy,
  rescale = FALSE,
  xmin = NA_real_,
  xmax = NA_real_,
  ymin = NA_real_,
  ymax = NA_real_,
  comp = "si"
)

cmsc_e1_tw(
  xxx,
  yyy,
  rescale = FALSE,
  xmin = NA_real_,
  xmax = NA_real_,
  ymin = NA_real_,
  ymax = NA_real_,
  comp = "si"
)

cmsc_e2_tw(
  xxx,
  yyy,
  rescale = FALSE,
  xmin = NA_real_,
  xmax = NA_real_,
  ymin = NA_real_,
  ymax = NA_real_,
  comp = "si"
)

gcsm_tw(
  xxx,
  yyy,
  rescale = FALSE,
  xmin = NA_real_,
  xmax = NA_real_,
  ymin = NA_real_,
  ymax = NA_real_,
  comp = "si"
)
}
\arguments{
\item{xxx}{A 3-d array with the 3rd dimension representing time.}

\item{yyy}{The other 3-d array.}

\item{rescale}{Rescale or not before computation.}

\item{xmin, xmax, ymin, ymax}{Normalization parameters. If \code{NA}, are calculated
from the ranges of \code{xxx} and \code{yyy}, respectively. See Details.}

\item{comp}{Variable to return. If \code{"si"}, the composite measure, if
\code{"s1"},\code{"s2"} or \code{"s3"}, the corresponding component.}
}
\value{
A matrix.
}
\description{
Compute composite measures, GCSM or CMSC, on temporal windows.
}
\details{
These functions slide the temporal window over space. Missing values are
omitted. Normalization parameters are used to rescale \code{xxx} and \code{yyy}, and
determine the global minimum (min) and maximum (max). If \code{rescale} is
\code{TRUE}, \code{xxx} and \code{yyy} are rescaled to \code{(xxx-xmin)/(xmax-xmin)} and
\code{(yyy-ymin)/(ymax-ymin)}; and set \code{min=0}, \code{max=1}. If \code{FALSE},
\code{min=min(xmin,ymin)}, \code{max=max(xmax,ymax)}. OpenMP is used for parallel
computing.
}
\examples{
x = array(runif(81), dim = c(3, 3, 9))

gcsm_tw(x, x + 0.2, xmin = 0, xmax = 1, ymin = 0, ymax = 1)
cmsc_tw(x, x + 0.2, xmin = 0, xmax = 1, ymin = 0, ymax = 1)
}
