% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepro.R
\name{preprocess_data}
\alias{preprocess_data}
\title{Preprocess data}
\usage{
preprocess_data(
  data,
  degree_polynomial = 1,
  interaction_terms = FALSE,
  verbose = 1,
  nw = 1,
  rm_near_zero_var = TRUE,
  rm_na = TRUE,
  add_cds = TRUE,
  rm_ucs = TRUE,
  rt_terms = 1,
  mandatory = c("NAME", "RT", "SMILES")
)
}
\arguments{
\item{data}{Dataframe with following columns:
\itemize{
\item Mandatory: NAME, RT and SMILES.
\item Recommmended: INCHIKEY.
\item Optional: Any of the chemical descriptors listed in \link{CDFeatures}.
All other columns will be removed.
See 'Details'.
}}

\item{degree_polynomial}{Add predictors with polynomial terms up to the specified degree, e.g. 2 means
"add squares", 3 means "add squares and cubes". Set to 1 to leave descriptors
unchanged.}

\item{interaction_terms}{Add interaction terms? Polynomial terms are not included in the generation of
interaction terms.}

\item{verbose}{0: no output, 1: show progress, 2: progress and warnings.}

\item{nw}{Number of workers to use for parallel processing.}

\item{rm_near_zero_var}{Remove near zero variance predictors?}

\item{rm_na}{Remove NA values?}

\item{add_cds}{Add chemical descriptors using \code{\link[=getCDs]{getCDs()}}? See 'Details'.}

\item{rm_ucs}{Remove unsupported columns?}

\item{rt_terms}{Which retention-time transformations to append as extra predictors. Supply a
numeric vector referencing predefined rt_terms (1=RT, 2=I(RT^2),
3=I(RT^3), 4=log(RT), 5=exp(RT), 6=sqrt(RT)) or a character vector with the
explicit transformation terms. Character values are passed to \code{\link[=model.frame]{model.frame()}},
so they must use valid formula syntax (e.g. "I(RT^2)" rather than "RT^2").}

\item{mandatory}{Character vector of mandatory columns that must be present in \code{data}. If any
of these columns are missing, an error is raised.}
}
\value{
A dataframe with the preprocessed data.
}
\description{
Preprocess data so they can be used as input for \code{\link[=train_frm]{train_frm()}}.
}
\details{
If \code{add_cds = TRUE}, chemical descriptors are added using \code{\link[=getCDs]{getCDs()}}. If
\strong{all} chemical descriptors listed in \link{CDFeatures} are already present in
the input \code{data} object, \code{\link[=getCDs]{getCDs()}} will leave them unchanged. If one or more
chemical descriptors are missing, \strong{all} chemical descriptors will be
recalculated and existing ones will be overwritten.
}
\examples{
data <- head(RP, 3)
pre <- preprocess_data(data, verbose = 0)
}
\keyword{public}
