#' Dataset from Babakus & Boller (1992)
#'
#' Data from Babakus & Boller (1992) who investigated the dimensionality of the SERVQUAL scale based on a sample of N = 502.
#' The data is available as a data.frame (simulated via mvrnorm in package MASS based on the correlation matrix provided by the authors) and used in the vignette.
#' @docType data
#' @usage data(bb1992)
#' @format A data.frame of 22 variables (Q1-Q22) with 502 observations
#' @keywords datasets
#' @references Babakus, E., & Boller, G. W. (1992). An empirical assessment of the SERVQUAL scale. Journal of Business Research, 24(3), 253–268. https://doi.org/10.1016/0148-2963(92)90022-4
#' @examples
#'data(bb1992)
#'head(bb1992, 3)
#' @source Provided in paper
"bb1992"
