% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prcompname.R
\name{prcompname}
\alias{prcompname}
\title{Create name for prcomp result}
\usage{
prcompname(prcompResult, PC, explvar = TRUE)
}
\arguments{
\item{prcompResult}{output value from \code{\link[stats]{prcomp}} function}

\item{PC}{PC number}

\item{explvar}{(logical) show explained variance (\%) or not}
}
\value{
String
}
\description{
Create name for \code{\link[stats]{prcomp}} result
}
\examples{
data(applejuice)
applejuice_uf <- unfold(applejuice) # unfold list into matrix
result <- prcomp(applejuice_uf) 
prcompname(result, 1)

}

