% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DepLogoR.R
\name{filterColumns}
\alias{filterColumns}
\title{Filters data columns by some filter function}
\usage{
filterColumns(data, filter.fun)
}
\arguments{
\item{data}{the data as \link{DLData} object}

\item{filter.fun}{the filter function}
}
\value{
a \link{DLData} object containing the filtered columns and the indexes of the remaining in its \code{axis.labels} field
}
\description{
Filters the columns of the input data, i.e., positions of input sequences,
by a filter function that, given a \link{DLData} object, returns a list containing
i) as element \code{$selected} a vector with entries \code{TRUE} for every column 
that should be retained in the filtered data and ii) as element \code{$range} the
range of values obtained for the filtering criterion.
}
\examples{
# read data and create DLData object
seqs <- read.table(system.file("extdata", "cjun.txt", package = "DepLogo"), 
    stringsAsFactors = FALSE)
data <- DLData(sequences = seqs[, 1], weights = log1p(seqs[, 2]) )

# create a filter function based on the percentage of gap symbols (at most 10\%)
fun <- filter.by.gaps(percent.gap = 0.1)
data2 <- filterColumns(data, fun)
}
\seealso{
\link{filter.by.gaps}

\link{filter.by.dependencies}

\link{filter.by.conservation}
}
\author{
Jan Grau <grau@informatik.uni-halle.de>
}
