/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.ibase.toolkit;

import java.util.Vector;
import org.rosuda.ibase.toolkit.Axis;
import org.rosuda.ibase.toolkit.PGSCanvas;
import org.rosuda.ibase.toolkit.PlotObject;
import org.rosuda.pograss.PoGraSS;

public class PlotManager {
    PGSCanvas c;
    Vector obj;
    int ptr;

    public PlotManager(PGSCanvas pGSCanvas) {
        this.c = pGSCanvas;
        this.obj = new Vector();
        this.ptr = -1;
    }

    public Axis getXAxis() {
        return this.c.getXAxis();
    }

    public Axis getYAxis() {
        return this.c.getYAxis();
    }

    public void drawLayer(PoGraSS poGraSS, int n, int n2) {
        for (int i = 0; i < this.obj.size(); ++i) {
            PlotObject plotObject = (PlotObject)this.obj.elementAt(i);
            if (plotObject == null || !plotObject.isVisible() || plotObject.layer != n && (plotObject.layer != -1 || n != n2 - 1)) continue;
            plotObject.draw(poGraSS);
        }
    }

    public void dispose() {
        this.ptr = -1;
        while (this.obj.size() > 0) {
            PlotObject plotObject = (PlotObject)this.obj.elementAt(0);
            if (plotObject != null) {
                plotObject.dispose();
            }
            try {
                this.obj.removeElement(plotObject);
            }
            catch (Exception exception) {}
        }
        this.obj.clear();
        this.obj = null;
        this.c = null;
    }

    public void add(PlotObject plotObject) {
        this.obj.addElement(plotObject);
        this.ptr = this.obj.size() - 1;
    }

    public void rm(PlotObject plotObject) {
        if (this.ptr < 0) {
            this.ptr = this.obj.size() - 1;
        }
        if (this.ptr >= 0) {
            PlotObject plotObject2 = (PlotObject)this.obj.elementAt(this.ptr);
            this.obj.removeElement(plotObject);
            if (plotObject2 == plotObject || this.ptr >= this.obj.size() || plotObject2 != this.obj.elementAt(this.ptr)) {
                this.ptr = this.obj.size() - 1;
            }
        } else {
            this.obj.removeElement(plotObject);
            this.ptr = this.obj.size() - 1;
        }
    }

    public int getCurrentID() {
        return this.ptr;
    }

    public void setCurrentID(int n) {
        this.ptr = n;
    }

    public PlotObject getCurrentObject() {
        return this.ptr >= 0 && this.ptr < this.obj.size() ? (PlotObject)this.obj.elementAt(this.ptr) : null;
    }

    public int setCurrentObject(PlotObject plotObject) {
        if (this.obj.size() < 1) {
            return -1;
        }
        for (int i = 0; i < this.obj.size(); ++i) {
            if (this.obj.elementAt(i) != plotObject) continue;
            this.ptr = i;
            return this.ptr;
        }
        return -1;
    }

    public void update(int n) {
        if (n > -1) {
            this.c.setUpdateRoot(n);
        } else {
            this.c.setUpdateRoot(this.c.layers - 1);
        }
        this.c.repaint();
    }

    public void update() {
        this.update(0);
    }

    public PlotObject get(int n) {
        return (PlotObject)this.obj.elementAt(n);
    }

    public int count() {
        return this.obj.size();
    }
}

