/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.deducer.models;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerListModel;
import org.rosuda.JGR.util.ErrorMsg;
import org.rosuda.deducer.Deducer;
import org.rosuda.deducer.models.GLMModel;
import org.rosuda.deducer.models.RModel;
import org.rosuda.deducer.toolkit.DJList;
import org.rosuda.deducer.toolkit.IconButton;
import org.rosuda.deducer.toolkit.OkayCancelPanel;

public class GLMExplorerPlots
extends JDialog
implements ActionListener {
    protected JPanel termPanel;
    protected JTextField ylab;
    protected JCheckBox rug;
    protected JLabel ylabLabel;
    protected JSpinner levels;
    protected JLabel pointsLabel;
    protected JCheckBox multi;
    protected JList terms;
    protected JPanel meansPanel;
    protected JPanel okayCancel;
    protected JCheckBox confInt;
    protected JCheckBox scaled;
    protected JPanel optionsPanel;
    protected JScrollPane meansScroller;
    protected JButton remove;
    protected JButton add;
    protected JList effects;
    protected JScrollPane termScroller;
    protected GLMModel model;

    public GLMExplorerPlots(JFrame jFrame, GLMModel gLMModel, RModel rModel) {
        super(jFrame);
        this.initGUI();
        this.setModel(gLMModel, rModel);
        this.setModal(true);
    }

    protected void initGUI() {
        try {
            this.getContentPane().setLayout(null);
            this.termPanel = new JPanel();
            Object[] objectArray = new BorderLayout();
            this.termPanel.setLayout((LayoutManager)objectArray);
            this.getContentPane().add(this.termPanel);
            this.termPanel.setBounds(12, 12, 170, 230);
            this.termPanel.setBorder(BorderFactory.createTitledBorder("Model Terms"));
            this.termScroller = new JScrollPane();
            this.termPanel.add((Component)this.termScroller, "Center");
            DefaultListModel defaultListModel = new DefaultListModel();
            this.terms = new DJList();
            this.termScroller.setViewportView(this.terms);
            this.terms.setModel(defaultListModel);
            this.meansPanel = new JPanel();
            objectArray = new BorderLayout();
            this.meansPanel.setLayout((LayoutManager)objectArray);
            this.getContentPane().add(this.meansPanel);
            this.meansPanel.setBounds(250, 12, 170, 230);
            this.meansPanel.setBorder(BorderFactory.createTitledBorder("Effects"));
            this.meansScroller = new JScrollPane();
            this.meansPanel.add((Component)this.meansScroller, "Center");
            defaultListModel = new DefaultListModel();
            this.effects = new DJList();
            this.meansScroller.setViewportView(this.effects);
            this.effects.setModel(defaultListModel);
            this.add = new IconButton("/icons/1rightarrow_32.png", "Add", this, "Add");
            this.getContentPane().add(this.add);
            this.add.setBounds(197, 86, 38, 38);
            this.remove = new IconButton("/icons/1leftarrow_32.png", "Remove", this, "Remove");
            this.getContentPane().add(this.remove);
            this.remove.setBounds(197, 124, 38, 38);
            this.okayCancel = new OkayCancelPanel(false, false, this);
            this.getContentPane().add(this.okayCancel);
            this.okayCancel.setBounds(205, 378, 207, 36);
            this.optionsPanel = new JPanel();
            this.getContentPane().add(this.optionsPanel);
            this.optionsPanel.setBounds(35, 254, 358, 118);
            this.optionsPanel.setLayout(null);
            this.optionsPanel.setBorder(BorderFactory.createTitledBorder("Options"));
            this.confInt = new JCheckBox();
            this.optionsPanel.add(this.confInt);
            this.confInt.setText("point-wise intervals");
            this.confInt.setBounds(17, 29, 171, 19);
            this.scaled = new JCheckBox();
            this.optionsPanel.add(this.scaled);
            this.scaled.setText("Scaled y-axis");
            this.scaled.setBounds(215, 88, 124, 18);
            this.multi = new JCheckBox();
            this.optionsPanel.add(this.multi);
            this.multi.setText("Multiple lines per panel");
            this.multi.setBounds(17, 60, 200, 18);
            this.pointsLabel = new JLabel();
            this.optionsPanel.add(this.pointsLabel);
            this.pointsLabel.setText("# of levels:");
            this.pointsLabel.setBounds(5, 90, 71, 14);
            this.pointsLabel.setHorizontalAlignment(4);
            objectArray = new String[80];
            for (int i = 1; i <= 80; ++i) {
                objectArray[i - 1] = i + "";
            }
            SpinnerListModel spinnerListModel = new SpinnerListModel(objectArray);
            this.levels = new JSpinner();
            this.optionsPanel.add(this.levels);
            this.levels.setModel(spinnerListModel);
            this.levels.setBounds(81, 87, 45, 21);
            this.ylabLabel = new JLabel();
            this.optionsPanel.add(this.ylabLabel);
            this.ylabLabel.setText("y-axis label");
            this.ylabLabel.setBounds(215, 20, 121, 14);
            this.ylabLabel.setHorizontalAlignment(0);
            this.ylabLabel.setHorizontalTextPosition(0);
            this.ylab = new JTextField();
            this.optionsPanel.add(this.ylab);
            this.ylab.setText("<auto>");
            this.ylab.setBounds(215, 34, 121, 21);
            this.ylab.setHorizontalAlignment(0);
            this.rug = new JCheckBox();
            this.optionsPanel.add(this.rug);
            this.rug.setText("rug");
            this.rug.setBounds(215, 60, 73, 18);
            this.setTitle("Effect Plots");
            this.setSize(432, 460);
        }
        catch (Exception exception) {
            new ErrorMsg(exception);
        }
    }

    public void updateModel() {
        this.model.plots.effects = (DefaultListModel)this.effects.getModel();
        this.model.plots.confInt = this.confInt.isSelected();
        this.model.plots.multi = this.multi.isSelected();
        this.model.plots.defaultLevels = Integer.parseInt((String)this.levels.getValue());
        this.model.plots.ylab = this.ylab.getText();
        this.model.plots.rug = this.rug.isSelected();
        this.model.plots.scaled = this.scaled.isSelected();
    }

    public void setModel(GLMModel gLMModel, RModel rModel) {
        int n;
        this.model = gLMModel;
        DefaultListModel<String> defaultListModel = new DefaultListModel<String>();
        String[] stringArray = new String[]{};
        try {
            stringArray = Deducer.timedEval("attr(terms(" + rModel.modelName + "),\"term.labels\")").asStrings();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        for (n = 0; n < stringArray.length; ++n) {
            defaultListModel.addElement(stringArray[n]);
        }
        this.terms.setModel(defaultListModel);
        for (n = 0; n < this.model.plots.effects.getSize(); ++n) {
            if (!defaultListModel.contains(this.model.plots.effects.elementAt(n))) continue;
            defaultListModel.removeElement(this.model.plots.effects.elementAt(n));
            ((DefaultListModel)this.effects.getModel()).addElement(this.model.plots.effects.elementAt(n));
        }
        this.confInt.setSelected(this.model.plots.confInt);
        this.multi.setSelected(this.model.plots.multi);
        this.levels.setValue(this.model.plots.defaultLevels + "");
        this.ylab.setText(this.model.plots.ylab);
        this.rug.setSelected(this.model.plots.rug);
        this.scaled.setSelected(this.model.plots.scaled);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        block3: {
            String string;
            block5: {
                block4: {
                    block2: {
                        string = actionEvent.getActionCommand();
                        if (string != "Cancel") break block2;
                        this.dispose();
                        break block3;
                    }
                    if (string != "OK") break block4;
                    this.updateModel();
                    this.dispose();
                    break block3;
                }
                if (string != "Add") break block5;
                Object[] objectArray = this.terms.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    ((DefaultListModel)this.terms.getModel()).removeElement(objectArray[i]);
                    if (objectArray[i] == null) continue;
                    ((DefaultListModel)this.effects.getModel()).addElement(objectArray[i]);
                }
                break block3;
            }
            if (string != "Remove") break block3;
            Object[] objectArray = this.effects.getSelectedValues();
            for (int i = 0; i < objectArray.length; ++i) {
                ((DefaultListModel)this.effects.getModel()).removeElement(objectArray[i]);
                if (objectArray[i] == null) continue;
                ((DefaultListModel)this.terms.getModel()).addElement(objectArray[i]);
            }
        }
    }
}

