% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plotROC}
\alias{plotROC}
\title{ROC Curve plot}
\usage{
plotROC(dets, ...)
}
\arguments{
\item{dets}{A 'DET' object from the list of a 'DETs' object computed by the \code{detc} function.}

\item{...}{Further graphical arguments passed to the plot function.}
}
\description{
From a 'DET' object, this function plots the ROC curve associated with the DET curve of the object. It also draws the confidence band when it is available in the object.
}
\examples{
library(DET)
n = 5000
#Predictors with normal distribution
set.seed(1235)
scoreNegative = rnorm(n, mean = 0.25, sd = 0.125)
set.seed(11452)
scorePositive = rnorm(n, mean = 0.55, sd = 0.125)
response = as.factor(c(rep(c("target"), times = n), rep(c("nontarget"), times = n)))
predictor = matrix(c(scoreNegative, scorePositive), ncol = 1)
colnames(predictor) = c("DET")
detCurve = detc(response,
                predictor,
                names = colnames(predictor),
                positive = "target")
plotROC(detCurve@detCurves$DET,
         main = "Example")
}
