\name{CoxLikelihood}
\alias{CoxLikelihood}
\title{
Robust Likelihood Ratio Test and Confidence Intervals for the Cox Model
}
\description{
Calculate the (robust) likelihood ratio test p-values and confidence intervals for the Cox model.
}
\usage{
CoxLikelihood(time, event, X, robust = TRUE, weights = NULL, alpha = 0.05)
}
\arguments{
  \item{time}{
time of the event or censoring.
}
  \item{event}{
a binary variable indicating whether the record is an event or is censored.  1 is for event, 0 is for censoring.
}
  \item{X}{
a numeric matrix specifing the dependent variables of the Cox model.
}
  \item{robust}{
specifying whether the robust p-values and confidence intervals will be calculated.  Default is TRUE.
}
  \item{weights}{
weights of each observation.  The default is one for each observation.
}
  \item{alpha}{
1-alpha is the confidence interval (or the target coverage) of the output confidence interval.
}
}
\details{
The robust likelihood ratio test p-value is based on a scaled chi-square distribution.  The robust likelihood confidence interval is generated by inverting the robust likelihood ratio test.  See Shao and Guo (2026) for details.
}
\value{
A data frame which gives the hazard ratio estimate, the robust likelihood ratio test p-values, and the robust likelihood confidence intervals.
}
\references{
Shao, Yongwu, and Xu Guo. "Likelihood confidence intervals for misspecified Cox models." arXiv preprint arXiv:2508.11851 (2025).
}
\author{
Yongwu Shao
}
\examples{
##Create example data;
set.seed(2026);
nSubj = 100;
event = rep(1, nSubj);
X = matrix(rnorm(nSubj * 3), nSubj, 3);
time = exp(-X[,2]/2 - X[,1]^2 + X[,3]);
X = X[,-3];

## Get the robust and regular likelihood confidence intervals
CoxLikelihood(time, event, X, robust = FALSE);
CoxLikelihood(time, event, X, robust = TRUE);}
