% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getRealGainingCoalitions.R
\name{getRealGainingCoalitions}
\alias{getRealGainingCoalitions}
\title{Compute real gaining coalitions of game}
\usage{
getRealGainingCoalitions(v)
}
\arguments{
\item{v}{Numeric vector of length 2^n - 1 representing the values of 
the coalitions of a TU game with n players}
}
\value{
A data frame containing all real gaining coalitions.
}
\description{
The function getRealGainingCoalitions identifies all real gaining coalitions.
Coalition \code{S} is a real gaining coalition if for any true subset \code{T} of \code{S} 
there holds: v(S) > v(T)
}
\examples{
library(CoopGame)
getRealGainingCoalitions(v=c(0,0,0,0,0,0,2))

\donttest{
library(CoopGame)
v <- c(1,2,3,4,0,0,0)
getRealGainingCoalitions(v)
# Output:
#    V1 V2 V3 cVal
# 1  1  0  0    1
# 2  0  1  0    2
# 3  0  0  1    3
# 4  1  1  0    4
}

}
\references{
Holler M.J. and Li X. (1995) "From public good index to public value. An axiomatic approach and generalization", Control and Cybernetics 24, pp. 257--270

Bertini C. and Stach I. (2015) "On Public Values and Power Indices", Decision Making in Manufacturing and Services 9(1), pp. 9--25
}
\author{
Johannes Anwander \email{anwander.johannes@gmail.com}

Jochen Staudacher \email{jochen.staudacher@hs-kempten.de}
}
