% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CentroidReasonableSetConcept.R
\name{drawCentroidReasonableSet}
\alias{drawCentroidReasonableSet}
\title{draw centroid of reasonable set for 3 or 4 players}
\usage{
drawCentroidReasonableSet(
  v,
  holdOn = FALSE,
  colour = NA,
  label = TRUE,
  name = "centroid of reasonable set"
)
}
\arguments{
\item{v}{Numeric vector of length 2^n - 1 representing the values of 
the coalitions of a TU game with n players}

\item{holdOn}{draws in a existing plot}

\item{colour}{draws the geometric object (i.e. point or convex polyhedron) with this colour, all colour names can be seen with "colors()"}

\item{label}{activates the labels for the figure}

\item{name}{set a name for the label}
}
\value{
None.
}
\description{
drawCentroidReasonableSet draws the centroid of the reasonable set for 3 or 4 players.
}
\examples{
library(CoopGame)
v <-c(1,2,3,60,60,60,142)
drawCentroidReasonableSet(v,colour="green")
}
\references{
Milnor J.W. (1953) \emph{Reasonable Outcomes for N-person Games}, Rand Corporation, Research Memorandum RM 916.

Branzei R., Dimitrov D. and Tijs S. (2006) \emph{Models in cooperative game theory}, Springer, p. 21

Chakravarty S.R., Mitra M. and Sarkar P. (2015) \emph{A Course on Cooperative Game Theory}, Cambridge University Press, pp. 43--44

Gerard-Varet L.A. and Zamir S. (1987) "Remarks on the reasonable set of outcomes in a general coalition function form game", Int. Journal of Game Theory 16(2), pp. 123--143
}
\author{
Jochen Staudacher \email{jochen.staudacher@hs-kempten.de}
}
