% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CostSharingGame.R
\name{costSharingGameValue}
\alias{costSharingGameValue}
\title{Compute value of a coalition for a cost game}
\usage{
costSharingGameValue(S, Costs)
}
\arguments{
\item{S}{numeric vector with coalition of players}

\item{Costs}{A vector containing the costs each coalition has to pay}
}
\value{
Cost savings of coalition S as compared to singleton coalitions
}
\description{
\strong{Coalition value for a cost sharing game:} \cr
For further information see \link{costSharingGame}
}
\examples{
library(CoopGame)
costSharingGameValue(S=c(1,2), Costs=c(2,2,2,3,3,3,4))

\donttest{
#Example with 3 students sharing an appartment:
#-------------------------------
#| costs     |  A  |  B  |  C  |
#- -----------------------------
#|single     | 300 | 270 | 280 |
#|appartment |     |     |     |
#-------------------------------
#
#Appartment for 2 persons => costs: 410
#Appartment for 3 persons => costs: 550

#Savings when A and B share appartment
library(CoopGame)
costSharingGameValue(S=c(1,2),Costs=c(300,270,280,410,410,410,550))
#Output: 
#[1] 160
}

}
\references{
Peleg B. and Sudhoelter P. (2007) \emph{Theory of cooperative games}, 2nd Edition, Springer, pp. 14--16

Maschler M., Solan E. and Zamir S. (2013) \emph{Game Theory}, Cambridge University Press, pp. 667--668
}
\author{
Johannes Anwander \email{anwander.johannes@gmail.com}

Jochen Staudacher \email{jochen.staudacher@hs-kempten.de}
}
