alfa.reg2 <- function(y, x, a, xnew = NULL) {

  reg <- function(para, ya, ax, a, ha, d, D) {
    be <- matrix(para, ncol = d)
    zz <- cbind( 1, exp(ax %*% be) )
    ta <- rowSums(zz)
    za <- zz / ta
    ma <- ( D / a * za - 1/a ) %*% ha
    as.vector(ya - ma)
  }

  runtime <- proc.time()

  res <- list()
  D <- dim(y)[2]
  d <- D - 1  ## dimensionality of the simplex
  p <- dim(x)[2] - 1
  x <- model.matrix(ya ~., data.frame(x) )
  ha <- t( Compositional::helm(D) )
  if ( is.null( colnames(x) ) ) {
    namx <- c("constant", paste("X", 1:p, sep = "") )
  } else {
    namx  <- c("constant", colnames(x)[-1] )
  }

  if ( min(y) == 0 )  a <- a[a > 0 ]
  la <- length(a)

  for ( i in 1:la ) {
    if ( a[i] <= 1e-4 ) {
      mod <- Compositional::comp.reg(y, x[, -1], yb = NULL)
      be <- mod$be
      if ( !is.null(seb) )  seb <- mod$seb

    } else {
      ya <- Compositional::alfa(y, a[i])$aff
      ax <- a[i] * x
      ini <- as.vector( solve(crossprod(x), crossprod(x, ya) ) )
      suppressWarnings({
      mod <- minpack.lm::nls.lm( par = ini, fn = reg, ya = ya, ax = ax, a = a[i], ha = ha, d = d, D = D,
                                 control = minpack.lm::nls.lm.control(maxiter = 10000) )
      })
      be <- matrix(mod$par, ncol = d)

    }  ## end if (a == 0)

    est <- NULL
    if ( !is.null(xnew) ) {
      xnew <- model.matrix(~., data.frame(xnew) )
      est <- cbind( 1, exp(xnew %*% be) )
      est <- est/Rfast::rowsums(est)
    }
    rownames(be) <- namx
    res[[ i ]] <- list(be = be, est = est)
  }

  res
}


