% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PPC_CoFM.R
\name{PPC_CoFM}
\alias{PPC_CoFM}
\title{Perform Projected PCA (PPC) Estimation for CoFM}
\usage{
PPC_CoFM(data, m, A, D)
}
\arguments{
\item{data}{A matrix or data frame of input data (n x p). Usually the \code{$data} output from \code{CoFM}.}

\item{m}{Integer. The number of principal components (factors) to retain.}

\item{A}{Matrix. The true factor loadings matrix (p x m). Usually \code{$True_Params$A} from \code{CoFM}.}

\item{D}{Matrix. The true uniquenesses matrix (p x p). Usually \code{$True_Params$D} from \code{CoFM}.}
}
\value{
A list containing:
\item{Ap2}{Estimated factor loadings matrix (Projected).}
\item{Dp2}{Estimated uniquenesses matrix (Projected).}
\item{MSESigmaA}{Mean Squared Error for factor loadings.}
\item{MSESigmaD}{Mean Squared Error for uniquenesses.}
\item{LSigmaA}{Relative loss metric for factor loadings.}
\item{LSigmaD}{Relative loss metric for uniquenesses.}
}
\description{
This function performs Projected Principal Component Analysis (PPC) on the input data to
estimate factor loadings and uniquenesses. It is designed to work with data generated by
the \code{\link{CoFM}} function and calculates error metrics (MSE and relative loss) by
comparing estimates against true parameters. The method projects data onto a subspace
(using a projection operator) before performing PCA.
}
\examples{
# Examples should be fast and reproducible for CRAN checks
set.seed(123)

# 1. Generate toy data using CoFM
sim_result <- CoFM(n = 200, p = 6, m = 2, type = "Clayton", param = 2.0)

# 2. Extract true parameters and observed data
true_A <- sim_result$True_Params$A
true_D <- sim_result$True_Params$D
obs_data <- sim_result$data

# 3. Apply PPC method and compute errors
ppc_result <- PPC_CoFM(data = obs_data, m = 2, A = true_A, D = true_D)

# 4. Inspect results
ppc_result$MSESigmaA
ppc_result$MSESigmaD
head(ppc_result$Ap2)
}
