% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NlmeCovariateParameter.r
\name{addCovariate}
\alias{addCovariate}
\title{Add covariate to model object}
\usage{
addCovariate(
  .Object,
  covariate,
  effect = NULL,
  type = c("Continuous", "Categorical", "Occasion"),
  direction = c("Forward", "Interpolate", "Backward"),
  option = c("Yes", "PlusOne", "No"),
  center = NULL,
  centerValue = NULL,
  levels = NULL,
  labels = NULL,
  isDiagonal = TRUE,
  values = NULL,
  isPositive = TRUE
)
}
\arguments{
\item{.Object}{Model object}

\item{covariate}{Name of covariate. If the involved model has columns
mapped (i.e. model with \code{columnMap = TRUE}) use named character if the name
of the covariate is different from the corresponding column in the input
dataset, for example, \code{covariate = c(BW = "BodyWeight")}, where \code{BW}
denotes the name of the covariate, and \code{"BodyWeight"} is the name of the
corresponding column in the input dataset.}

\item{effect}{Name of structural parameter(s) on which the covariate
has an effect. Specify \code{effect} as character or character vector if the
covariate has an effect on multiple structural parameters.
\strong{Important for Occasion Covariates:} When modifying an \emph{existing}
occasion covariate (e.g., changing \code{option} or \code{values}), you must
list \emph{all} structural parameters currently affected by this occasion
covariate in the \code{effect} argument, even those whose effect relationship
is not being changed in this specific call.}

\item{type}{Type of covariate. Options are \code{"Continuous"},
\code{"Categorical"}, \code{"Occasion"}.}

\item{direction}{Direction of missing values propagation (if no covariate
value is given). Options are \code{"Forward"}, \code{"Interpolate"}, \code{"Backward"},
where \code{"Interpolate"} is only applicable to \code{type = "Continuous"}.}

\item{option}{Options are \code{"Yes"}, \code{"PlusOne"}, or \code{"No"}.
\itemize{
\item \code{"Yes"}: Apply the covariate effect using the standard method
(multiplicative for LogNormal style, additive for Normal style).
\item \code{"PlusOne"}: Apply the covariate effect using the "1 + effect"
formulation. This is only applicable to continuous and categorical
covariates where the affected structural parameter has \code{style = "LogNormal"}.
\item \code{"No"}: Remove the specified covariate effect from the specified
structural parameter(s). The covariate itself (and its definition,
e.g., \code{fcovariate(Occ1)}) remains part of the model, but the link
between this covariate and the specified parameter(s) in the \code{stparm()}
statement is removed. See the note for the \code{effect} argument regarding
occasion covariates.
Multiple options are not supported within a single call (i.e., all
covariate effects listed in the \code{effect} argument for a single call must
use the same \code{option}). If different \code{option}s are required, use sequential
calls to \code{addCovariate}.
}}

\item{center}{Centering method. Options are \code{"Mean"}, \code{"Median"},
\code{"Value"} or \code{"None"}. Only applicable to covariate \code{type = "Continuous"}.
Must include argument \code{centerValue} if \code{center = "Value"}.}

\item{centerValue}{Value used to center covariate. Only applicable if
argument \code{center = "Value"} and \code{type = "Continuous"}.}

\item{levels}{Unique values of categorical or occasion covariate.  Only
applicable to covariate \code{type = "Categorical"} or \code{type = "Occasion"}.}

\item{labels}{Label names (in the same order as levels) for unique levels of
categorical or occasion covariate in data. Only applicable to covariate
\code{type = "Categorical"}  or \code{type = "Occasion"} where its corresponding
column in the input dataset has character type.}

\item{isDiagonal}{Set to \code{FALSE} if inter-occasion covariance matrix is not
diagonal matrix. Only applicable to covariate \code{type = "Occasion"}.}

\item{values}{Initial values for the diagonal elements of the inter-occasion
covariance matrix (if \code{isDiagonal = TRUE}) or initial values for the lower
triangular elements (including diagonal elements) of inter-occasion
covariance matrix (if \code{isDiagonal = FALSE}) in a row-wise order. Only
applicable for covariate \code{type = "Occasion"}.}

\item{isPositive}{Set to \code{FALSE} if covariate contains negative values.
Only applicable to covariate \code{type = "Continuous"}.}
}
\value{
Modified \code{NlmePmlModel} object
}
\description{
Add a continuous, categorical, or occasion covariate to model object and set
covariate effect on structural parameters.
}
\details{
The following relationships are applicable for covariates:
\itemize{
\item \code{direction = "Forward"} is equivalent to PML code 'fcovariate(CovName)';
\item \code{direction = "Backward"} is equivalent to PML code 'covariate(CovName)';
\item \code{direction = "Interpolate"} is equivalent to PML code 'interpolate(CovName)'.

If the structural parameter has \code{style = "LogNormal"}, the options are
reflected in PML code as follows:
\item \code{option = "Yes"} is equivalent to
\code{stparm(V = tvV * wt^dVdwt * exp(dVdsex1*(sex==1)) * exp(nV))};
\item \verb{option = "PlusOne} is equivalent to
\code{stparm(V = tvV * (1+wt*dVdwt) * (1+dVdsex1*(sex==1)) * exp(nV))}.
}
}
\examples{
model <- pkmodel(
  numCompartments = 2,
  data = pkData,
  ID = "Subject",
  Time = "Act_Time",
  A1 = "Amount",
  CObs = "Conc",
  workingDir = tempdir()
)

# Add Gender covariate of type categorical
model <- addCovariate(model,
  covariate = "Gender",
  type = "Categorical",
  effect = c("V2", "Cl2"),
  levels = c(0, 1),
  labels = c("Female", "Male")
)

# Add BodyWeight covariate of type continuous
model <- addCovariate(model,
  covariate = "BodyWeight",
  type = "Continuous",
  direction = "Backward",
  center = "Mean",
  effect = c("V", "Cl")
)
}
