% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/profile_estimation.r
\name{RunProfilePertubation}
\alias{RunProfilePertubation}
\title{Execute an NLME profile perturbation}
\usage{
RunProfilePertubation(
  hostPlatform,
  dataset,
  params,
  profiles,
  sortColumns,
  scenarios = list(),
  runInBackground = FALSE,
  workingDir = NULL
)
}
\arguments{
\item{hostPlatform}{How to execute the run(NlmeParallelHost)}

\item{dataset}{Dataset and model information(NlmeDataset)}

\item{params}{Engine parameters(NlmeEngineExtraParams)}

\item{profiles}{Profiles to perturbate(ProfileParameters)}

\item{sortColumns}{Optional list of columns to sort and fit(SortColumns)}

\item{scenarios}{Optional list of scenarios to fit(NlmeScenario)}

\item{runInBackground}{TRUE will run in background and return prompt(Bool)}

\item{workingDir}{Directory in which to run the job. Current working directory is used if \code{NULL}}
}
\value{
Object of class \code{ProfileNlmeJob}
}
\description{
Execute an NLME profile perturbation
}
\examples{
\dontrun{
  model <- pkmodel(
    parameterization = "Clearance",
    numCompartments = 2,
    data = pkData,
    ID = "Subject",
    Time = "Act_Time",
    A1 = "Amount",
    CObs = "Conc",
    workingDir = tempdir()
  )

  params <- NlmeEngineExtraParams(
    method = 3,
    numIterations = 1
  )

  host <- hostParams(
    sharedDirectory = tempdir(),
    parallelMethod = "None",
    hostName = "Local",
    numCores = 4
  )

  profile1 <- ProfileVar(
    "tvV",
    9.548,
    "-2,0,2"
  )

  profile2 <- ProfileVar(
    "tvCl",
    0.919,
    "-0.5,0,1.5"
  )

  profiles <- ProfileParameters(
    "USE_DELTA",
    c(profile1, profile2)
  )

  job <- profilePertubate(
    hostPlatform = host,
    params = params,
    profiles = profiles,
    model = model
  )
}
}
\keyword{internal}
