% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/micro_array-network.R
\name{inference,micro_array-method}
\alias{inference,micro_array-method}
\alias{inference}
\alias{inference-methods}
\title{Reverse-engineer the network}
\usage{
\S4method{inference}{micro_array}(
  M,
  tour.max = 30,
  g = function(x) {
     1/x
 },
  conv = 0.001,
  cv.subjects = TRUE,
  nb.folds = NULL,
  eps = 10^-5,
  type.inf = "iterative"
)
}
\arguments{
\item{M}{a micro_array object.}

\item{tour.max}{maximal number of steps. Defaults to `tour.max=30`}

\item{g}{the new solution is choosen as
(the old solution + g(x) * the new solution)/(1+g(x)) where x is the number
of steps. Defaults to `g=function(x) 1/x`}

\item{conv}{convergence criterion. Defaults to `conv=10e-3`}

\item{cv.subjects}{should the cross validation be done removing the
subject one by one ? Defaults to `cv.subjects=TRUE`.}

\item{nb.folds}{Relevant only if cv.subjects is
FALSE. The number of folds in cross validation. Defaults to `NULL`.}

\item{eps}{machine zero. Defaults to `10e-5`.}

\item{type.inf}{"iterative" or "noniterative" : should the
algorithm be computed iteratively. Defaults to `"iterative"`.}
}
\value{
A network object.
}
\description{
Reverse-engineer the network.
}
\examples{

\donttest{
#With simulated data
data(M)
infM <- inference(M)
str(infM)

#With selection of genes from GSE39411
data(Selection)
infSel <- inference(Selection)
str(infSel)
}

}
\references{
Jung, N., Bertrand, F., Bahram, S., Vallat, L., and
Maumy-Bertrand, M. (2014). Cascade: a R-package to study, predict and
simulate the diffusion of a signal through a temporal gene network.
\emph{Bioinformatics}, btt705.

Vallat, L., Kemper, C. A., Jung, N., Maumy-Bertrand, M., Bertrand, F.,
Meyer, N., ... & Bahram, S. (2013). Reverse-engineering the genetic
circuitry of a cancer cell with predicted intervention in chronic
lymphocytic leukemia. \emph{Proceedings of the National Academy of
Sciences}, 110(2), 459-464.
}
\author{
Nicolas Jung, Frédéric Bertrand , Myriam Maumy-Bertrand.
}
\keyword{methods}
