% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/external_tools.R
\name{track_external_tools}
\alias{track_external_tools}
\title{Track External Bioinformatics Tools}
\usage{
track_external_tools(tools = NULL, registry_file)
}
\arguments{
\item{tools}{Character vector of tool names to track. If NULL, tracks common tools.}

\item{registry_file}{Character. Path to tools registry. Default ".capsule/tools_registry.json"}
}
\value{
List containing tool version information
}
\description{
Track versions of external command-line tools commonly used in bioinformatics
pipelines (e.g., samtools, STAR, BWA, etc.)
}
\examples{
\dontrun{
# Track common bioinformatics tools
track_external_tools(registry_file = tempfile(fileext = ".json"))

# Track specific tools
track_external_tools(c("samtools", "bwa", "STAR"),
                     registry_file = tempfile(fileext = ".json"))
}
}
