% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BoneDensityFunctions.R
\name{surface_normal_intersect}
\alias{surface_normal_intersect}
\title{Find material properties of bone at surface point using surface normal}
\usage{
surface_normal_intersect(
  surface_mesh,
  mapped_coords = NULL,
  normal_dist = 3,
  nifti,
  ct_eqn = NULL,
  ct_params = NULL,
  rev_x = FALSE,
  rev_y = FALSE,
  rev_z = FALSE,
  check_in_vol = FALSE
)
}
\arguments{
\item{surface_mesh}{Mesh object}

\item{mapped_coords}{Data frame. 3D coords of remapped surface points. If
NULL, surface_mesh vertices will be used}

\item{normal_dist}{Numeric. Distance surface normal should penetrate surface}

\item{nifti}{Nifti CT scan image}

\item{ct_eqn}{String. Equation to use for density calibration. Currently
"linear" supported.}

\item{ct_params}{Numeric vector. Calibration parameters for density
calculation. For linear, first value is beta coefficient (y intercept),
second value is sigma coefficient (gradient)}

\item{rev_x}{Logical. Reverses x voxel coordinates}

\item{rev_y}{Logical. Reverses y voxel coordinates}

\item{rev_z}{Logical. Reverses z voxel coordinates}

\item{check_in_vol}{Logical. Include check that model is in scans volume
and print dimensions}
}
\value{
Vector. Vector with value for each point on surface
}
\description{
Find material properties of bone at surface point using surface normal
}
\examples{
\donttest{
  # Download CT scan
  url <- "https://github.com/Telfer/BoneDensityMapping/releases/download/v1.0.2/test_CT_hip.nii.gz"
  scan_filepath <- tempfile(fileext = ".nii.gz")
  download.file(url, scan_filepath, mode = "wb")
  nifti <- import_scan(scan_filepath)
  url2 <- "https://github.com/Telfer/BoneDensityMapping/releases/download/v1.0.2/test_CT_femur.stl"
  bone_filepath <- tempfile(fileext = ".stl")
  download.file(url2, bone_filepath, mode = "wb")
  surface_mesh <- import_mesh(bone_filepath)
  landmark_path <- system.file("extdata", "test_femur.mrk.json",
                               package = "BoneDensityMapping")
  landmarks <- import_lmks(landmark_path)
  mapped_coords <- surface_points_template(surface_mesh, landmarks,
                                           no_surface_sliders = 1000)
  mat_peak <- surface_normal_intersect(surface_mesh, normal_dist = 3.0,
                                       nifti = nifti, ct_eqn = "linear",
                                       ct_params = c(68.4, 1.106))
}
}
\author{
Scott Telfer \email{scott.telfer@gmail.com}
}
