% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auto_viol_cont.R
\name{auto_viol_cont}
\alias{auto_viol_cont}
\title{auto_viol_cont}
\usage{
auto_viol_cont(
  data,
  groupvar,
  violinplot_args = list(),
  theme_func = theme_serene,
  lang_labs = c("EN", "SPA")
)
}
\arguments{
\item{data}{Name of the dataframe}

\item{groupvar}{Name of the grouping variable}

\item{violinplot_args}{List of arguments to be passed to "geom_violin"}

\item{theme_func}{Theme to display plots. Default is "theme_serene"}

\item{lang_labs}{Language of the resulting plots. Can be "EN" for english or "SPA" for spanish. Default is "SPA".}
}
\value{
Returns a list containing barplots as ggplot2 objects. Objects can be accessed via $ operator.
}
\description{
Automatically generates violinplots of continuous variables from a database and a grouping variable. The names of the variables are set to the names defined in the database. As a result, graphs generated with the default theme "theme_serene" will be obtained. In this function it is not possible to use labels for the variables, use "auto_viol_cont_wlabels" instead.
}
\examples{

data <- data.frame(group = rep(letters[1:2], 30),
var1 = rnorm(30, mean = 15, sd = 5),
var2 = rnorm(30, mean = 20, sd = 2),
var3 = rnorm(30, mean = 10, sd = 1),
var4 = rnorm(30, mean = 5, sd =2))

data$group<-as.factor(data$group)

# Create a list containing all the plots
violinplots<-auto_viol_cont(data = data, groupvar = 'group', lang_labs = 'EN')

# call to show all storaged plots
violinplots

# call to show one individual plots
violinplots$var1


}
\author{
JMCR
}
