% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normal.R
\name{bi.dist.normal}
\alias{bi.dist.normal}
\title{Samples from a Normal (Gaussian) distribution.}
\usage{
bi.dist.normal(
  loc = 0,
  scale = 1,
  validate_args = py_none(),
  name = "x",
  obs = py_none(),
  mask = py_none(),
  sample = FALSE,
  seed = py_none(),
  shape = c(),
  event = 0,
  create_obj = FALSE,
  to_jax = TRUE
)
}
\arguments{
\item{loc}{A numeric vector, matrix, or array representing the mean of the distribution.}

\item{scale}{A numeric vector, matrix, or array representing the standard deviation of the distribution.}

\item{validate_args}{Logical: Whether to validate parameter values.  Defaults to `reticulate::py_none()`.}

\item{name}{A character string representing the name of the random variable
within a model. This is used to uniquely identify the variable. Defaults to 'x'.}

\item{obs}{A numeric vector or array of observed values. If provided, the
random variable is conditioned on these values. If `NULL`, the variable is
treated as a latent (unobserved) variable. Defaults to `NULL`.}

\item{mask}{A logical vector, matrix, or array. Optional boolean array to mask observations.}

\item{sample}{A logical value that controls the function's behavior. If `TRUE`,
the function will directly draw samples from the distribution. If `FALSE`,
it will create a random variable within a model. Defaults to `FALSE`.}

\item{seed}{An integer used to set the random seed for reproducibility when
`sample = TRUE`. This argument has no effect when `sample = FALSE`, as
randomness is handled by the model's inference engine. Defaults to 0.}

\item{shape}{A numeric vector specifying the shape of the distribution.  Use a vector (e.g., `c(10)`) to define the shape.}

\item{event}{An integer representing the number of batch dimensions to reinterpret as event dimensions (used in model building).}

\item{create_obj}{A logical value. If `TRUE`, returns the raw BI distribution object instead of creating a sample site.}

\item{to_jax}{Boolean. Indicates whether to return a JAX array or not.}
}
\value{
- When \code{sample=FALSE}: A BI Normal distribution object (for model building).

 - When \code{sample=TRUE}: A JAX array of samples drawn from the Normal distribution (for direct sampling).

 - When \code{create_obj=TRUE}: The raw BI distribution object (for advanced use cases).
}
\description{
The Normal distribution is characterized by its mean (loc) and standard deviation (scale).
It's a continuous probability distribution that arises frequently in statistics and  probability theory.
\deqn{
f(x \mid \mu, \sigma) = \frac{1}{\sqrt{2\pi}\sigma}\exp!\left(-\frac{(x - \mu)^2}{2\sigma^2}\right)
}
}
\examples{
\donttest{
library(BayesianInference)
m=importBI(platform='cpu')
bi.dist.normal(sample = TRUE)
}
}
