% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphics_func.R
\name{USDmapCount}
\alias{USDmapCount}
\title{Draw spatial maps of various quantities over regions in the US}
\usage{
USDmapCount(state.sel,dat,scol,tcol=NULL,tsel=NULL,cname,uplim=NULL)
}
\arguments{
\item{state.sel}{character vector giving the selected states}

\item{dat}{data frame having named components: y - the necessary quantity (numeric), sid - the region indices, tid - the time indices}

\item{scol}{column index of the spatial regions}

\item{tcol}{(optional) column index of the time points}

\item{tsel}{(optional) selected time point}

\item{cname}{character vector of county names, must match those in USAcities}

\item{uplim}{(optional) numeric, upper limit for the given quantity}
}
\value{
spatial map of the required quantity over the specified region
}
\description{
Creates a map of any given quantity (at a selected time or averaged over time) for regions in the US specified by state and county
}
\examples{
data(simdat)
data(county.adjacency)
data(USAcities)
IAcities <- subset(USAcities,state_id=="IA")
countyname <- unique(IAcities$county_name)
USDmapCount(state.sel="IA",dat=simdat,scol=1,tcol=2,tsel=150,cname=countyname)

}
