% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plot_hyperparams_traceplot}
\alias{plot_hyperparams_traceplot}
\title{Plot Hyperparameters Traceplot}
\usage{
plot_hyperparams_traceplot(
  bktr_reg,
  hyperparameters = NULL,
  show_figure = TRUE,
  fig_width = 9,
  fig_height = 5.5,
  fig_resolution = 200
)
}
\arguments{
\item{bktr_reg}{BKTRRegressor: BKTRRegressor object.}

\item{hyperparameters}{Array or NULL: Array of hyperparameters to plot.
If NULL, plot all hyperparameters. Defaults to NULL.}

\item{show_figure}{Boolean: Whether to show the figure. Defaults to True.}

\item{fig_width}{Integer: Figure width. Defaults to 9.}

\item{fig_height}{Integer: Figure height. Defaults to 5.5.}

\item{fig_resolution}{Numeric: Figure resolution PPI. Defaults to 200.}
}
\value{
ggplot or NULL: ggplot object or NULL if show_figure is set to FALSE.
}
\description{
Plot the evolution of hyperparameters through iterations. (Traceplot)
}
\examples{
\dontshow{if (torch::torch_is_installed()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Launch MCMC sampling on a light version of the BIXI dataset
bixi_data <- BixiData$new(is_light = TRUE)
k_matern <- KernelMatern$new()
k_periodic <- KernelPeriodic$new()
bktr_regressor <- BKTRRegressor$new(
  data_df <- bixi_data$data_df,
  spatial_kernel = k_matern,
  temporal_kernel = k_periodic,
  spatial_positions_df = bixi_data$spatial_positions_df,
  temporal_positions_df = bixi_data$temporal_positions_df,
  burn_in_iter = 5, sampling_iter = 10) # For example only (too few iterations)
bktr_regressor$mcmc_sampling()

# Plot the traceplot of all hyperparameters
plot_hyperparams_traceplot(bktr_regressor)

# Plot the traceplot of the spatial kernel hyperparameters
spa_par_name <- paste0('Spatial - ', k_matern$parameters[[1]]$full_name)
plot_hyperparams_traceplot(bktr_regressor, spa_par_name)

# Plot the traceplot of the temporal kernel hyperparameters
temp_par_names <- sapply(k_periodic$parameters, function(x) x$full_name)
temp_par_names <- paste0('Temporal - ', temp_par_names)
plot_hyperparams_traceplot(bktr_regressor, temp_par_names)
\dontshow{\}) # examplesIf}
}
