% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/initialize.hyp.parm.R
\name{initialize.hyp.parm}
\alias{initialize.hyp.parm}
\title{Initialize hyperparmeters for BCFM model}
\usage{
initialize.hyp.parm(
  model.attributes,
  cluster.hyperparms,
  n.sigma = 2.2,
  n.s2.sigma = 0.1,
  n.tau = 1,
  n.s2.tau = 1,
  omega.diag.nu = 2,
  p.exponent = NA
)
}
\arguments{
\item{model.attributes}{Model attributes generated by initialize.model.attributes}

\item{cluster.hyperparms}{Cluster related hyperparameters generated by initialize.cluster.hyperparms}

\item{n.sigma}{The shape parameter of sigma^2. If not specified, 6.}

\item{n.s2.sigma}{The rate parameter of sigma^2. If not specified, 4.}

\item{n.tau}{The shape parameter of tau^2. If not specified, 6.}

\item{n.s2.tau}{The rate parameter of tau^2. If not specified, 4.}

\item{omega.diag.nu}{The shape parameter for the first cluster covariance}

\item{p.exponent}{The Dirichlet priors of probabilities.}
}
\value{
A list of fixed hyperparmeters of mu, Omega and sigma squared.
}
\description{
The function returns a list of hyperparameters of Omega, sigma^2 and mu. It also calls the results from cluster.hyperparms and information from model.attributes.
}
