% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/revised_echarts4r_functions.R
\name{e_x_axis_full}
\alias{e_x_axis_full}
\title{Enhanced X-Axis Setter for echarts4r}
\usage{
e_x_axis_full(
  e,
  index = 0,
  serie = NULL,
  axis = "x",
  xAxis.title = NULL,
  xAxis.position = "bottom",
  xAxis.nameLocation = "center",
  xAxis.axisTick.customValues = NULL,
  xAxis.nameTextStyle.color = NULL,
  xAxis.nameTextStyle.padding = 15,
  xAxis.nameTextStyle.align = NULL,
  xAxis.nameTextStyle.fontStyle = NULL,
  xAxis.nameTextStyle.fontWeight = NULL,
  xAxis.nameTextStyle.fontSize = NULL,
  xAxis.nameTextStyle.fontFamily = NULL,
  xAxis.min = NULL,
  xAxis.max = NULL,
  xAxis.splitNumber = NULL,
  xAxis.axisLabel.rotate = NULL,
  xAxis.axisLabel.margin = NULL,
  xAxis.axisLabel.color = NULL,
  xAxis.axisLabel.fontStyle = NULL,
  xAxis.axisLabel.fontWeight = NULL,
  xAxis.axisLabel.fontFamily = NULL,
  xAxis.axisLabel.fontSize = NULL,
  xAxis.axisLabel.align = NULL,
  xAxis.axisLabel.verticalAlign = NULL,
  xAxis.axisLabel.backgroundColor = NULL,
  xAxis.axisLabel.borderColor = NULL,
  xAxis.axisLabel.borderWidth = NULL,
  xAxis.axisLabel.borderType = NULL,
  xAxis.axisLabel.borderRadius = NULL,
  xAxis.axisLabel.padding = NULL,
  xAxis.axisLabel.shadowColor = NULL,
  xAxis.axisLabel.shadowBlur = NULL,
  xAxis.axisLabel.shadowOffsetX = NULL,
  xAxis.axisLabel.shadowOffsetY = NULL,
  xAxis.axisLabel.textBorderColor = NULL,
  xAxis.axisLabel.textBorderWidth = NULL,
  xAxis.axisLabel.textBorderType = NULL,
  xAxis.axisLabel.textShadowColor = NULL,
  xAxis.axisLabel.textShadowBlur = NULL,
  xAxis.axisLabel.textShadowOffsetX = NULL,
  xAxis.axisLabel.textShadowOffsetY = NULL,
  xAxis.axisLabel.overflow = NULL
)
}
\arguments{
\item{e}{An echarts4r object}

\item{index}{Which x axis to target (zero-based). Default: 0}

\item{serie}{NULL}

\item{axis}{"x"}

\item{xAxis.title}{Axis title}

\item{xAxis.position}{'bottom', 'top'}

\item{xAxis.nameLocation}{'center', 'start', 'middle'}

\item{xAxis.axisTick.customValues}{Custom values for the x-axis}

\item{xAxis.nameTextStyle.color}{hex or named color}

\item{xAxis.nameTextStyle.padding}{numeric}

\item{xAxis.nameTextStyle.align}{'center', 'left', 'right'}

\item{xAxis.nameTextStyle.fontStyle}{'italic', 'normal' 'oblique'}

\item{xAxis.nameTextStyle.fontWeight}{'normal', 'bold', 'bolder', 'lighter'}

\item{xAxis.nameTextStyle.fontSize}{numeric}

\item{xAxis.nameTextStyle.fontFamily}{'sans-serif', 'serif', 'monospace', 'Arial', 'Times New Roman', 'Roboto', 'Open Sans', 'Lato', 'Helvetica', 'Georgia', 'Verdana', 'Arial', 'Tahoma', 'Courier New'}

\item{xAxis.min}{Min value}

\item{xAxis.max}{Max value}

\item{xAxis.splitNumber}{numeric. Increments for numeric axis labels}

\item{xAxis.axisLabel.rotate}{numeric}

\item{xAxis.axisLabel.margin}{numeric}

\item{xAxis.axisLabel.color}{hex or named}

\item{xAxis.axisLabel.fontStyle}{'italic', 'normal' 'oblique'}

\item{xAxis.axisLabel.fontWeight}{'normal', 'bold', 'bolder', 'lighter'}

\item{xAxis.axisLabel.fontFamily}{'sans-serif', 'serif', 'monospace', 'Arial', 'Times New Roman', 'Roboto', 'Open Sans', 'Lato', 'Helvetica', 'Georgia', 'Verdana', 'Arial', 'Tahoma', 'Courier New'}

\item{xAxis.axisLabel.fontSize}{numeric}

\item{xAxis.axisLabel.align}{'center', 'left', 'right'}

\item{xAxis.axisLabel.verticalAlign}{'top', 'bottom'}

\item{xAxis.axisLabel.backgroundColor}{hex or named}

\item{xAxis.axisLabel.borderColor}{hex or named}

\item{xAxis.axisLabel.borderWidth}{numeric}

\item{xAxis.axisLabel.borderType}{'solid', 'dashed', 'dotted'}

\item{xAxis.axisLabel.borderRadius}{numeric}

\item{xAxis.axisLabel.padding}{numeric}

\item{xAxis.axisLabel.shadowColor}{hex or named}

\item{xAxis.axisLabel.shadowBlur}{numeric}

\item{xAxis.axisLabel.shadowOffsetX}{numeric}

\item{xAxis.axisLabel.shadowOffsetY}{numeric}

\item{xAxis.axisLabel.textBorderColor}{hex or named}

\item{xAxis.axisLabel.textBorderWidth}{numeric}

\item{xAxis.axisLabel.textBorderType}{'solid', 'dashed', 'dotted'}

\item{xAxis.axisLabel.textShadowColor}{hex or named}

\item{xAxis.axisLabel.textShadowBlur}{numeric}

\item{xAxis.axisLabel.textShadowOffsetX}{numeric}

\item{xAxis.axisLabel.textShadowOffsetY}{numeric}

\item{xAxis.axisLabel.overflow}{'truncate'}
}
\value{
The modified echarts4r object
}
\description{
Exposes every xAxis.* option so you don't have to hand-craft the JSON.
}
