% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotFunctions.R
\name{Plot.Histogram}
\alias{Plot.Histogram}
\title{Plot.Histogram}
\usage{
Plot.Histogram(
  dt = NULL,
  SampleSize = 30000L,
  XVar = NULL,
  YVar = NULL,
  GroupVar = NULL,
  YVarTrans = "Identity",
  XVarTrans = "Identity",
  FacetRows = 1,
  FacetCols = 1,
  FacetLevels = NULL,
  NumberBins = 30,
  Height = NULL,
  Width = NULL,
  EchartsTheme = "macarons",
  Title = "Histogram",
  MouseScroll = TRUE,
  TimeLine = FALSE,
  ShowLabels = FALSE,
  Title.YAxis = NULL,
  Title.XAxis = NULL,
  TextColor = "white",
  title.fontSize = 22,
  title.fontWeight = "bold",
  title.textShadowColor = "#63aeff",
  title.textShadowBlur = 3,
  title.textShadowOffsetY = 1,
  title.textShadowOffsetX = -1,
  xaxis.fontSize = 14,
  yaxis.fontSize = 14,
  Debug = FALSE
)
}
\arguments{
\item{dt}{source data.table}

\item{SampleSize}{An integer for the number of rows to use. Sampled data is randomized. If NULL then ignored}

\item{XVar}{X-Axis variable name}

\item{YVar}{Y-Axis variable name}

\item{GroupVar}{Column name of Group Variable for distinct colored histograms by group levels}

\item{YVarTrans}{"Asinh", "Log", "LogPlus1", "Sqrt", "Asin", "Logit", "PercRank", "Standardize", "BoxCox", "YeoJohnson"}

\item{XVarTrans}{"Asinh", "Log", "LogPlus1", "Sqrt", "Asin", "Logit", "PercRank", "Standardize", "BoxCox", "YeoJohnson"}

\item{FacetRows}{Defaults to 1 which causes no faceting to occur vertically. Otherwise, supply a numeric value for the number of output grid rows}

\item{FacetCols}{Defaults to 1 which causes no faceting to occur horizontally. Otherwise, supply a numeric value for the number of output grid columns}

\item{FacetLevels}{Faceting rows x columns is the max number of levels allowed in a grid. If your GroupVar has more you can supply the levels to display.}

\item{NumberBins}{= 30}

\item{Height}{"400px"}

\item{Width}{"200px"}

\item{EchartsTheme}{= EchartsTheme,}

\item{Title}{character}

\item{MouseScroll}{logical, zoom via mouse scroll}

\item{TimeLine}{logical}

\item{ShowLabels}{FALSE}

\item{Title.YAxis}{NULL}

\item{Title.XAxis}{NULL}

\item{TextColor}{"white"}

\item{title.fontSize}{22}

\item{title.fontWeight}{"bold"}

\item{title.textShadowColor}{'#63aeff'}

\item{title.textShadowBlur}{3}

\item{title.textShadowOffsetY}{1}

\item{title.textShadowOffsetX}{-1}

\item{xaxis.fontSize}{14}

\item{yaxis.fontSize}{14}

\item{Debug}{Debugging purposes}
}
\value{
plot
}
\description{
Build a histogram plot by simply passing arguments to a single function. It will sample your data using SampleSize number of rows. Sampled data is randomized.
}
\examples{
# Create fake data
dt <- data.table::data.table(Y = qnorm(p = stats::runif(10000)))

# Create plot
AutoPlots::Plot.Histogram(
  dt = dt,
  SampleSize = 30000L,
  XVar = NULL,
  YVar = "Y",
  GroupVar = NULL,
  YVarTrans = "Identity",
  XVarTrans = "Identity",
  FacetRows = 1,
  FacetCols = 1,
  FacetLevels = NULL,
  NumberBins = 30,
  Height = NULL,
  Width = NULL,
  EchartsTheme = "macarons",
  Title = "Histogram",
  MouseScroll = TRUE,
  TimeLine = FALSE,
  ShowLabels = FALSE,
  Title.YAxis = NULL,
  Title.XAxis = NULL,
  TextColor = "white",
  title.fontSize = 22,
  title.fontWeight = "bold",
  title.textShadowColor = '#63aeff',
  title.textShadowBlur = 3,
  title.textShadowOffsetY = 1,
  title.textShadowOffsetX = -1,
  xaxis.fontSize = 14,
  yaxis.fontSize = 14,
  Debug = FALSE)
}
\seealso{
Other Standard Plots: 
\code{\link{ACF}()},
\code{\link{Area}()},
\code{\link{Bar}()},
\code{\link{BarPlot3D}()},
\code{\link{Box}()},
\code{\link{Copula}()},
\code{\link{Copula3D}()},
\code{\link{CorrMatrix}()},
\code{\link{Density}()},
\code{\link{Donut}()},
\code{\link{HeatMap}()},
\code{\link{Histogram}()},
\code{\link{Line}()},
\code{\link{PACF}()},
\code{\link{Parallel}()},
\code{\link{Pie}()},
\code{\link{Plot.ACF}()},
\code{\link{Plot.Area}()},
\code{\link{Plot.Bar}()},
\code{\link{Plot.BarPlot3D}()},
\code{\link{Plot.Box}()},
\code{\link{Plot.Copula}()},
\code{\link{Plot.Copula3D}()},
\code{\link{Plot.CorrMatrix}()},
\code{\link{Plot.Density}()},
\code{\link{Plot.Donut}()},
\code{\link{Plot.HeatMap}()},
\code{\link{Plot.Line}()},
\code{\link{Plot.PACF}()},
\code{\link{Plot.Parallel}()},
\code{\link{Plot.Pie}()},
\code{\link{Plot.ProbabilityPlot}()},
\code{\link{Plot.Radar}()},
\code{\link{Plot.River}()},
\code{\link{Plot.Rosetype}()},
\code{\link{Plot.Scatter}()},
\code{\link{Plot.Scatter3D}()},
\code{\link{Plot.StackedBar}()},
\code{\link{Plot.Step}()},
\code{\link{Plot.WordCloud}()},
\code{\link{ProbabilityPlot}()},
\code{\link{Radar}()},
\code{\link{River}()},
\code{\link{Rosetype}()},
\code{\link{Scatter}()},
\code{\link{Scatter3D}()},
\code{\link{StackedBar}()},
\code{\link{Step}()},
\code{\link{WordCloud}()}
}
\author{
Adrian Antico
}
\concept{Standard Plots}
