% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TukeyTest.R
\name{TukeyTest}
\alias{TukeyTest}
\title{Tukey HSD Test for Multiple Comparisons v2.0}
\usage{
TukeyTest(modelo, comparar = NULL, alpha = 0.05)
}
\arguments{
\item{modelo}{An \code{aov} or \code{lm} object (full model: includes blocks, factors, etc.).}

\item{comparar}{Character vector with the name(s) of the factor(s) to compare:
- One name: main effect (e.g., "treatment" or "A")
- Several names: interaction (e.g., \code{c("A","B")} for \code{A:B})
If omitted, it uses the first factor in \code{modelo$xlevels}.}

\item{alpha}{Significance level (default 0.05).}
}
\value{
An object of class \code{"tukey"} and \code{"comparaciones"} containing:
\itemize{
  \item \code{Resultados}: a data.frame with columns \code{Comparacion}, \code{Diferencia}, \code{SE}, \code{t_value},
        \code{p_value} (unadjusted), \code{p_ajustada} (Tukey), \code{Valor_Critico} (critical difference), and \code{Significancia}.
  \item \code{Promedios}: a named vector of group means as defined by \code{comparar}.
  \item \code{Orden_Medias}: group names ordered from highest to lowest mean.
  \item \code{Metodo}: "Tukey test".
  \item \code{Termino}: the term being compared (e.g., "A", "B", or "A:B").
  \item \code{MSerror}, \code{df_error}, \code{N}: useful for plots with error bars.
}
}
\description{
Performs Tukey's Honest Significant Difference (HSD) test for all pairwise
comparisons after fitting an ANOVA model. This post hoc method uses the
studentized range distribution and is appropriate when variances are equal
across groups and observations are independent.
}
\details{
Tukey's test controls the family-wise error rate and is widely used when group
comparisons have not been planned in advance.

Advantages:
- Strong control of Type I error rate.
- Ideal for balanced designs with equal variances.

Disadvantages:
- Assumes equal variances and sample sizes.
- Less powerful with heteroscedasticity.
}
\examples{

#Caso DCA
data(d_e, package = "Analitica")
mod1 <- aov(Sueldo_actual ~ as.factor(labor), data = d_e)
summary(mod1)
resultado <- TukeyTest(mod1)
summary(resultado)
plot(resultado)

#Caso DBA
mod2 <- aov(Sueldo_actual ~ as.factor(labor) + Sexo, data = d_e)
summary(mod2)
# Comparar niveles de 'tratamiento' (ajustando el error por el modelo con bloque)
res <- TukeyTest(mod2, comparar = "as.factor(labor)")
summary(res)
plot(res)

#Caso DFA Two Ways
mod3 <- aov(Sueldo_actual ~ as.factor(labor) * Sexo, data = d_e)
summary(mod3)
# promedios de as.factor(labor) (promediando sobre B)
resA <- TukeyTest(mod3, comparar = "as.factor(labor)")
summary(resA)
plot(resA)

# promedios de la interaccion entre factor A y factor B
resB <- TukeyTest(mod3, comparar = c("as.factor(labor)","Sexo"))
summary(resB)
plot(resB)

}
\references{
Tukey, J. W. (1949). "Comparing individual means in the analysis of variance." \emph{Biometrics}, 5(2), 99–114. <https://doi.org/10.2307/3001913>
}
