% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ATM_plot.R
\name{plot_age_topics}
\alias{plot_age_topics}
\title{Title plot the topic loadings across age.}
\usage{
plot_age_topics(
  disease_names,
  trajs,
  plot_title = "",
  start_age = 30,
  top_ds = 10
)
}
\arguments{
\item{disease_names}{the list of disease names, ordered as the topic.}

\item{trajs}{one disease topic, which should be a matrix of age-by-disease.}

\item{plot_title}{the title of the figure.}

\item{start_age}{starting age of the matrix, default 30.}

\item{top_ds}{How many disease to show, default is 10. This will filter the disease by
the average topic laodings across age and pick the top.}
}
\value{
a ggplot object of the topic loading.
}
\description{
Title plot the topic loadings across age.
}
\examples{
disease_list <- UKB_349_disease \%>\%
dplyr::left_join(disease_info_phecode_icd10, by = c("diag_icd10"="phecode" )) \%>\%
dplyr::pull(phenotype)
topic_id <- 1 # plot the first topic
plot_age_topics(disease_names = disease_list,
        trajs = UKB_HES_10topics[30:80,,topic_id],
        plot_title = paste0("topic ", topic_id),
        top_ds = 7)
}
