% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WriteVoxelSpace.R
\docType{methods}
\name{writeVoxelSpace}
\alias{writeVoxelSpace}
\title{Write a voxel file}
\usage{
writeVoxelSpace(vxsp, f)
}
\arguments{
\item{vxsp}{the object of class VoxelSpace to write}

\item{f}{a character string naming a file.}
}
\description{
write a voxel file out of a \code{\linkS4class{VoxelSpace}}
object.
}
\examples{
\dontrun{
# load a voxel file
vxsp <- readVoxelSpace(system.file("extdata", "tls_sample.vox", package = "AMAPVox"))
# set max PAD to 5
vxsp@data[, PadBVTotal:=sapply(PadBVTotal, min, 5)]
# write updated voxel file in temporary file
writeVoxelSpace(vxsp, tempfile("pattern"="amapvox_", fileext=".vox"))
}
}
\seealso{
\code{\link[=readVoxelSpace]{readVoxelSpace()}}
}
