% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{ss_prsum}
\alias{ss_prsum}
\title{Compute pro-rated sum}
\usage{
ss_prsum(
  data,
  name,
  vars,
  max_na = NULL,
  exclude = NULL,
  events = NULL,
  as_integer = TRUE,
  combine = TRUE
)
}
\arguments{
\item{data}{tbl. Data frame containing the columns to be summarized.}

\item{name}{character. The name of the summary score.}

\item{vars}{character vector. The names of the columns to be summarized.}

\item{max_na}{numeric, positive whole number. Number of missing items
allowed (Default: NULL; no restriction on missing values).}

\item{exclude}{character (vector). The value(s) to be excluded (Default:
NULL; all values are used).}

\item{events}{character (vector). Only compute the summary score for the
specified events (Default: NULL; computed for all events).}

\item{as_integer}{logical. Whether to coerce the summary score to an integer,
default is \code{TRUE}. If \code{FALSE}, the summary score will be a double.}

\item{combine}{logical. Whether to combine the summary score column with the
input data frame (Default: TRUE).}
}
\value{
tbl. The input data frame with the summary score appended as a new
column.
}
\description{
Computes the pro-rated sum of a set of variables, with the option to
exclude certain values (for non-responses like
"Don't know"/"Decline to answer") and to set a maximum number of
missing values. Also include a second field
}
\examples{
data <- tibble::tibble(
  participant_id = c("A", "A", "A", "B", "A", "B", "A"),
  session_id     = c("ses-00A", "ses-01A", "ses-02A", "ses-02A", "ses-03A", "0ses-3A", "ses-04A"),
  a              = c(1, 2, 3, 4, 5, NA, 1),
  b              = c(1, 777, 3, 4, NA, NA, NA),
  c              = c(1, 2, 999, 4, 777, NA, NA),
  d              = c(1, 2, 3, 777, 999, NA, NA),
  e              = c(NA, 2, 3, NA, 5, NA, NA)
)

data |>
  ss_prsum(
    name = "score_prorated_sum",
    vars = c("a", "b", "c", "d", "e"),
    max_na = 1,
    exclude = c("777", "999")
  )

data |>
  ss_prsum(
    name = "score_prorated_sum",
    vars = c("a", "b", "c", "d", "e"),
    max_na = 1,
    exclude = c("777", "999"),
    combine = FALSE
  )

data |>
  ss_prsum(
    name = "score_prorated_sum",
    vars = c("a", "b", "c", "d", "e"),
    max_na = NULL,
    exclude = NULL,
    events = c("ses-00A", "ses-01A"),
  )
}
