% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scores_mh.R
\name{ss_nm_mh_ple}
\alias{ss_nm_mh_ple}
\title{Count missing values for MH-PLE scores}
\usage{
ss_nm_mh_ple(
  data,
  name,
  fork_vars,
  fork_val = "1",
  vars,
  exclude = NULL,
  events = NULL,
  combine = TRUE
)
}
\arguments{
\item{data}{Data frame containing columns to summarize}

\item{name}{String specifying name for summary score column}

\item{fork_vars}{Character vector of columns used as logical conditions}

\item{fork_val}{String indicating value in fork_vars for valid responses}

\item{vars}{Character vector of columns to summarize}

\item{exclude}{Character vector of values to exclude}

\item{events}{Character vector of events to compute scores for}

\item{combine}{Logical; if TRUE, append score to input data}
}
\value{
Data frame with count of missing values
}
\description{
Counts missing values for variables with forking logic, where variables may
only be applicable based on certain conditions. Excluded values are treated
as missing.
}
\examples{
data <- tibble::tribble(
  ~session_id, ~a, ~b, ~c, ~a__severe, ~b__severe, ~c__severe,
  "ses-00A", "1", "1", "1", "1", NA, NA,
  "ses-01A", "1", "1", "1", "2", "777", "2"
)

data |>
  ss_nm_mh_ple(
    name = "nm",
    fork_vars = c("a", "b", "c"),
    vars = paste0(c("a", "b", "c"), "__severe"),
    exclude = c("777", "999")
  )
}
\keyword{internal}
