/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.ssf.multivariate;

import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.data.DataBlockIterator;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.math.matrices.LowerTriangularMatrix;
import jdplus.toolkit.base.core.ssf.ISsfLoading;
import jdplus.toolkit.base.core.ssf.ISsfState;
import jdplus.toolkit.base.core.ssf.multivariate.ISsfErrors;
import jdplus.toolkit.base.core.ssf.multivariate.ISsfMeasurements;

public interface IMultivariateSsf
extends ISsfState {
    public ISsfMeasurements measurements();

    default public ISsfLoading loading(int eq) {
        return this.measurements().loading(eq);
    }

    default public ISsfErrors errors() {
        return this.measurements().errors();
    }

    default public int measurementsCount() {
        return this.measurements().getCount();
    }

    default public void xL(int pos, DataBlock x, FastMatrix M, FastMatrix R, int[] used) {
        this.dynamics().XT(pos, x);
        DataBlock w = DataBlock.make(M.getColumnsCount());
        w.product(x, M.columnsIterator());
        LowerTriangularMatrix.solvexL(R, w, 1.0E-9);
        for (int i = 0; i < used.length; ++i) {
            this.loading(used[i]).XpZd(pos, x, -w.get(i));
        }
    }

    default public void XL(int pos, FastMatrix X, FastMatrix M, FastMatrix R, int[] used) {
        DataBlockIterator rows = X.rowsIterator();
        DataBlock w = DataBlock.make(M.getColumnsCount());
        while (rows.hasNext()) {
            DataBlock x = rows.next();
            this.dynamics().XT(pos, x);
            w.product(x, M.columnsIterator());
            LowerTriangularMatrix.solvexL(R, w, 1.0E-9);
            for (int i = 0; i < used.length; ++i) {
                this.loading(used[i]).XpZd(pos, x, -w.get(i));
            }
        }
    }

    default public void XtL(int pos, FastMatrix X, FastMatrix M, FastMatrix R, int[] used) {
        DataBlockIterator cols = X.columnsIterator();
        DataBlock w = DataBlock.make(M.getColumnsCount());
        while (cols.hasNext()) {
            DataBlock x = cols.next();
            this.dynamics().XT(pos, x);
            w.product(x, M.columnsIterator());
            LowerTriangularMatrix.solvexL(R, w, 1.0E-9);
            for (int i = 0; i < used.length; ++i) {
                this.loading(used[i]).XpZd(pos, x, -w.get(i));
            }
        }
    }
}

