/*
 * Decompiled with CFR 0.152.
 */
package internal.toolkit.base.core.math.linearfilters;

import jdplus.toolkit.base.api.math.Complex;
import jdplus.toolkit.base.api.math.ComplexType;
import jdplus.toolkit.base.api.util.Ref;
import jdplus.toolkit.base.core.math.ComplexMath;
import jdplus.toolkit.base.core.math.ComplexUtility;
import jdplus.toolkit.base.core.math.polynomials.LeastSquaresDivision;
import jdplus.toolkit.base.core.math.polynomials.NewtonOptimizer;
import jdplus.toolkit.base.core.math.polynomials.Polynomial;
import jdplus.toolkit.base.core.math.polynomials.RootsSolver;

public class SymmetricMullerNewtonSolver
implements RootsSolver {
    private double[] m_p;
    private double[] m_pred;
    private Complex[] m_roots;
    private Polynomial m_remainder;
    private int m_idx;
    private int m_degree;
    private double m_maxerr;
    private static final int MITERMAX = 150;
    private static final int MCONVERGENCE = 100;
    private static final double MMAXDIST = 1000.0;
    private static final double MFACTOR = 100000.0;
    private static final double MKITERMAX = 1000.0;
    private static final double MFVALUE = 1.0E36;
    private static final double MBOUND1 = 1.01;
    private static final double MBOUND2 = 0.99;
    private static final double MBOUND3 = 0.01;
    private final double MBOUND4 = Math.sqrt(Double.MAX_VALUE) / 10000.0;
    private final double MBOUND6 = Math.log10(this.MBOUND4) - 4.0;
    private static final double MBOUND7 = 1.0E-5;
    private final double MNOISESTART;
    private static final double MNOISEMAX = 5.0;
    private static final int NITERMAX = 20;
    private static final double NFACTOR = 5.0;
    private static final double NFVALUE = 1.0E36;
    private static final double ISQRT2 = 1.0 / Math.sqrt(2.0);
    private final double NBOUND = Math.sqrt(2.220446049250313E-16);
    private static final int NNOISEMAX = 5;
    private static final double DBL_EPSILON = 2.220446049250313E-16;
    Complex x0 = Complex.ZERO;
    Complex x1 = Complex.ZERO;
    Complex x2 = Complex.ZERO;
    Complex h1 = Complex.ZERO;
    Complex h2 = Complex.ZERO;
    Complex q2 = Complex.ZERO;
    final Ref<Complex> f0 = new Ref((Object)Complex.ZERO);
    final Ref<Complex> f1 = new Ref((Object)Complex.ZERO);
    final Ref<Complex> f2 = new Ref((Object)Complex.ZERO);
    int iter;
    private boolean lqdiv = false;
    private static final Complex[] COMPLEX_FOR_ITER = SymmetricMullerNewtonSolver.initComplexForIter(150);

    private static void fdvalue(double[] p, int i0, Ref<Complex> f, Complex x) {
        int n = p.length - 1;
        double re = p[n];
        double im = 0.0;
        double xr = x.getRe();
        double xi = x.getIm();
        for (int i = n - 1; i >= i0; --i) {
            double rtmp = xr * re - xi * im + p[i];
            double itmp = xr * im + re * xi;
            re = rtmp;
            im = itmp;
        }
        f.val = Complex.cart((double)re, (double)im);
    }

    private static void fdvalue(double[] p, int i0, Ref<Complex> f, Ref<Complex> df, Complex x) {
        int n = p.length - 1;
        double xr = x.getRe();
        double xi = x.getIm();
        double fr2 = p[n];
        double fi = 0.0;
        double dfr2 = 0.0;
        double dfi = 0.0;
        for (int i = n - 1; i >= i0; --i) {
            double tr = xr * dfr2 - xi * dfi + fr2;
            double ti = xr * dfi + dfr2 * xi + fi;
            dfr2 = tr;
            dfi = ti;
            tr = xr * fr2 - xi * fi + p[i];
            ti = xr * fi + fr2 * xi;
            fr2 = tr;
            fi = ti;
        }
        df.val = Complex.cart((double)dfr2, (double)dfi);
        f.val = Complex.cart((double)fr2, (double)fi);
    }

    public SymmetricMullerNewtonSolver() {
        this.MNOISESTART = 2.220446049250313E-14;
    }

    private void check_x_value(Ref<Complex> xb, Ref.DoubleRef f2absqb, Ref.BooleanRef rootd, double f1absq, double f2absq, double epsilon, Ref.IntRef noise) {
        if (f2absq <= 1.01 * f1absq && f2absq >= 0.99 * f1absq) {
            if (this.h2.abs() < 0.01) {
                this.q2 = this.q2.times(2.0);
                this.h2 = this.h2.times(2.0);
            } else {
                this.q2 = SymmetricMullerNewtonSolver.getComplexForIterationCounter(this.iter);
                this.h2 = this.h2.times(this.q2);
            }
        } else if (f2absq < f2absqb.val) {
            f2absqb.val = f2absq;
            xb.val = this.x2;
            noise.val = 0;
            if (Math.sqrt(f2absq) < epsilon && this.x2.minus(this.x1).div(this.x2).abs() < epsilon) {
                rootd.val = true;
            }
        }
    }

    public void clear() {
        this.m_roots = null;
        this.m_remainder = null;
    }

    private void compute_function(double f1absq, Ref.DoubleRef f2absq, double epsilon) {
        Ref.IntRef overflow = new Ref.IntRef(0);
        do {
            overflow.val = 0;
            this.suppress_overflow();
            SymmetricMullerNewtonSolver.fdvalue(this.m_pred, this.m_idx, this.f2, this.x2);
            this.too_big_functionvalues(f2absq);
            ++this.iter;
            this.convergence_check(overflow, f1absq, f2absq.val, epsilon);
        } while (overflow.val != 0);
    }

    private void convergence_check(Ref.IntRef overflow, double f1absq, double f2absq, double epsilon) {
        if (f2absq > 100.0 * f1absq && this.q2.abs() > epsilon && this.iter < 150) {
            this.q2 = this.q2.times(0.5);
            this.h2 = this.h2.times(0.5);
            this.x2 = this.x2.minus(this.h2);
            overflow.val = 1;
        }
    }

    private boolean isSymmetric(Polynomial p) {
        int d = p.degree();
        for (int i = 0; i <= d / 2; ++i) {
            if (!(Math.abs(p.get(i) - p.get(d - i)) > 1.0E-9)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean factorize(Polynomial p) {
        if (!this.isSymmetric(p)) {
            return false;
        }
        this.m_degree = p.degree();
        this.m_roots = new Complex[this.m_degree / 2];
        this.m_p = new double[this.m_degree + 1];
        p.copyTo(this.m_p, 0);
        this.m_pred = (double[])this.m_p.clone();
        if (!this.newtonnull()) {
            return false;
        }
        this.m_remainder = Polynomial.valueOf(p.get(this.m_degree), new double[0]);
        return true;
    }

    private void initialize(Ref<Complex> xb, Ref.DoubleRef epsilon) {
        this.x0 = Complex.ZERO;
        this.x1 = Complex.cart((double)(-ISQRT2), (double)(-ISQRT2));
        this.x2 = Complex.cart((double)ISQRT2, (double)ISQRT2);
        this.h1 = this.x1.minus(this.x0);
        this.h2 = this.x2.minus(this.x1);
        this.q2 = this.h2.div(this.h1);
        xb.val = this.x2;
        epsilon.val = 2.220446049250313E-11;
        this.iter = 0;
    }

    private void iteration_equation(Ref.DoubleRef h2abs) {
        this.h2 = this.h2.times(this.q2);
        double h2absnew = this.h2.abs();
        if (h2absnew > h2abs.val * 1000.0) {
            double help = 1000.0 / h2absnew;
            this.h2 = this.h2.times(help);
            this.q2 = this.q2.times(help);
        }
        h2abs.val = h2absnew;
        this.x2 = this.x2.plus(this.h2);
    }

    private void rescale() {
        int n = this.m_p.length - 1;
        double factor = Math.abs(1.0 / this.m_p[n]);
        if (factor != 1.0) {
            int i = 0;
            while (i <= n) {
                int n2 = i++;
                this.m_p[n2] = this.m_p[n2] * factor;
            }
        }
    }

    private Complex muller() {
        Ref.DoubleRef f2absq = new Ref.DoubleRef(1.0E36);
        Ref.DoubleRef f2absqb = new Ref.DoubleRef(1.0E36);
        Ref.DoubleRef h2abs = new Ref.DoubleRef(0.0);
        Ref.DoubleRef epsilon = new Ref.DoubleRef(0.0);
        Ref.IntRef seconditer = new Ref.IntRef(0);
        Ref.IntRef noise = new Ref.IntRef(0);
        Ref.BooleanRef rootd = new Ref.BooleanRef(false);
        Ref xb = new Ref((Object)Complex.ZERO);
        this.initialize((Ref<Complex>)xb, epsilon);
        SymmetricMullerNewtonSolver.fdvalue(this.m_pred, this.m_idx, this.f0, this.x0);
        SymmetricMullerNewtonSolver.fdvalue(this.m_pred, this.m_idx, this.f1, this.x1);
        SymmetricMullerNewtonSolver.fdvalue(this.m_pred, this.m_idx, this.f2, this.x2);
        while (true) {
            this.root_of_parabola();
            this.x0 = this.x1;
            this.x1 = this.x2;
            h2abs.val = this.h2.abs();
            this.iteration_equation(h2abs);
            this.f0.val = this.f1.val;
            this.f1.val = this.f2.val;
            double f1absq = f2absq.val;
            this.compute_function(f1absq, f2absq, epsilon.val);
            this.check_x_value((Ref<Complex>)xb, f2absqb, rootd, f1absq, f2absq.val, epsilon.val, noise);
            double xb_abs = ((Complex)xb.val).abs();
            if (Math.abs(xb_abs - this.x2.abs()) / xb_abs < this.MNOISESTART) {
                ++noise.val;
            }
            if (this.iter <= 150 && !rootd.val && (double)noise.val <= 5.0) continue;
            ++seconditer.val;
            this.root_check(f2absqb.val, seconditer, rootd, noise, (Complex)xb.val);
            if (seconditer.val != 2) break;
        }
        return (Complex)xb.val;
    }

    private boolean newtonnull() {
        this.m_maxerr = 0.0;
        this.roots_at_zero();
        if (this.m_idx == this.m_p.length - 1) {
            return true;
        }
        if (this.quadratic()) {
            this.m_maxerr = 2.220446049250313E-16;
            return true;
        }
        this.rescale();
        do {
            NewtonOptimizer optimizer = new NewtonOptimizer(Polynomial.of(this.m_pred, this.m_idx, this.m_p.length), true);
            Complex ns = this.muller();
            Complex nroot = optimizer.root(ns);
            double newerr = optimizer.getError();
            if (newerr > this.m_maxerr) {
                this.m_maxerr = newerr;
            }
            if (nroot.getIm() == 0.0 ? !this.update(nroot.getRe()) : !this.update(nroot)) {
                return false;
            }
            Polynomial P = Polynomial.of(this.m_p);
            Complex[] croots = this.roots(this.m_idx / 2);
            ComplexUtility.lejaOrder(croots);
            Polynomial Pcur = Polynomial.fromComplexRoots(croots);
            LeastSquaresDivision lsq = new LeastSquaresDivision();
            lsq.divide(P, Pcur);
            lsq.getQuotient().copyTo(this.m_pred, this.m_idx);
        } while (this.m_p.length - this.m_idx > 3);
        return this.m_idx == this.m_degree || this.quadratic();
    }

    private boolean quadratic() {
        if (this.m_idx != this.m_degree - 2) {
            return false;
        }
        double a = this.m_pred[this.m_idx + 2];
        double b = this.m_pred[this.m_idx + 1];
        double c = this.m_pred[this.m_idx];
        double aa = 2.0 * a;
        double rdiscr = b * b - 4.0 * a * c;
        if (rdiscr >= 0.0) {
            double z = Math.sqrt(rdiscr);
            this.m_roots[this.m_idx / 2] = b < 0.0 ? Complex.cart((double)((-b + z) / aa)) : Complex.cart((double)((-b - z) / aa));
            return true;
        }
        if (rdiscr < -1.0E-6) {
            return false;
        }
        this.m_roots[this.m_idx / 2] = Complex.cart((double)(-b / aa));
        return true;
    }

    @Override
    public Polynomial remainder() {
        return this.m_remainder;
    }

    private void root_check(double f2absqb, Ref.IntRef seconditer, Ref.BooleanRef rootd, Ref.IntRef noise, Complex xb) {
        Ref df = new Ref((Object)Complex.ZERO);
        if (seconditer.val == 1 && f2absqb > 0.0) {
            SymmetricMullerNewtonSolver.fdvalue(this.m_pred, this.m_idx, this.f2, (Ref<Complex>)df, xb);
            if (((Complex)this.f2.val).abs() / (((Complex)df.val).abs() * xb.abs()) > 1.0E-5) {
                this.x0 = Complex.ONE;
                this.x1 = Complex.NEG_ONE;
                this.x2 = Complex.ZERO;
                SymmetricMullerNewtonSolver.fdvalue(this.m_pred, this.m_idx, this.f0, this.x0);
                SymmetricMullerNewtonSolver.fdvalue(this.m_pred, this.m_idx, this.f1, this.x1);
                SymmetricMullerNewtonSolver.fdvalue(this.m_pred, this.m_idx, this.f2, this.x2);
                this.iter = 0;
                ++seconditer.val;
                rootd.val = false;
                noise.val = 0;
            }
        }
    }

    private void root_of_parabola() {
        double N2_abs;
        Complex A2 = SymmetricMullerNewtonSolver.computeA2(this.q2, (Complex)this.f2.val, (Complex)this.f0.val, (Complex)this.f1.val);
        Complex B2 = SymmetricMullerNewtonSolver.computeB2((Complex)this.f2.val, (Complex)this.f1.val, this.q2, (Complex)this.f0.val);
        Complex C2 = SymmetricMullerNewtonSolver.computeC2(this.q2, (Complex)this.f2.val);
        Complex rdiscr = ComplexMath.sqrt((ComplexType)SymmetricMullerNewtonSolver.computeDiscr(B2, A2, C2));
        Complex N1 = B2.minus(rdiscr);
        Complex N2 = B2.plus(rdiscr);
        double N1_abs = N1.abs();
        this.q2 = N1_abs > (N2_abs = N2.abs()) && N1_abs > 2.220446049250313E-16 ? C2.times(-2.0).div(N1) : (N2_abs > 2.220446049250313E-16 ? C2.times(-2.0).div(N2) : SymmetricMullerNewtonSolver.getComplexForIterationCounter(this.iter));
    }

    static Complex computeA2(Complex q2, Complex f2, Complex f0, Complex f1) {
        double re0 = q2.getRe();
        double im0 = q2.getIm();
        double re1 = f2.getRe();
        double im1 = f2.getIm();
        double re2 = q2.getRe() * f0.getRe() - q2.getIm() * f0.getIm();
        double im2 = q2.getRe() * f0.getIm() + q2.getIm() * f0.getRe();
        re1 += re2;
        im1 += im2;
        re2 = 1.0 + q2.getRe();
        im2 = q2.getIm();
        double tmp = re2 * f1.getRe() - im2 * f1.getIm();
        im2 = re2 * f1.getIm() + im2 * f1.getRe();
        re2 = tmp;
        tmp = re0 * (re1 -= re2) - im0 * (im1 -= im2);
        im0 = re0 * im1 + im0 * re1;
        re0 = tmp;
        return Complex.cart((double)re0, (double)im0);
    }

    static Complex computeB2(Complex f2, Complex f1, Complex q2, Complex f0) {
        double re0 = f2.getRe() - f1.getRe();
        double im0 = f2.getIm() - f1.getIm();
        double re1 = q2.getRe();
        double im1 = q2.getIm();
        double re2 = q2.getRe();
        double im2 = q2.getIm();
        double re3 = f0.getRe() - f1.getRe();
        double im3 = f0.getIm() - f1.getIm();
        double tmp = re2 * re3 - im2 * im3;
        im2 = re2 * im3 + im2 * re3;
        re2 = tmp;
        re3 = f2.getRe() - f1.getRe();
        im3 = f2.getIm() - f1.getIm();
        tmp = re1 * (re2 += (re3 *= 2.0)) - im1 * (im2 += (im3 *= 2.0));
        im1 = re1 * im2 + im1 * re2;
        re1 = tmp;
        return Complex.cart((double)(re0 += re1), (double)(im0 += im1));
    }

    static Complex computeC2(Complex q2, Complex f2) {
        double re0 = 1.0 + q2.getRe();
        double im0 = q2.getIm();
        double tmp = re0 * f2.getRe() - im0 * f2.getIm();
        im0 = re0 * f2.getIm() + im0 * f2.getRe();
        re0 = tmp;
        return Complex.cart((double)re0, (double)im0);
    }

    static Complex computeDiscr(Complex B2, Complex A2, Complex C2) {
        double re0 = B2.getRe() * B2.getRe() - B2.getIm() * B2.getIm();
        double im0 = B2.getRe() * B2.getIm() + B2.getIm() * B2.getRe();
        double re1 = A2.getRe() * C2.getRe() - A2.getIm() * C2.getIm();
        double im1 = A2.getRe() * C2.getIm() + A2.getIm() * C2.getRe();
        return Complex.cart((double)(re0 -= (re1 *= 4.0)), (double)(im0 -= (im1 *= 4.0)));
    }

    @Override
    public Complex[] roots() {
        return this.roots(this.m_roots.length);
    }

    private Complex[] roots(int nr) {
        Complex[] r = new Complex[nr * 2];
        for (int i = 0; i < nr; ++i) {
            r[2 * i] = this.m_roots[i];
            r[2 * i + 1] = this.m_roots[i].inv();
        }
        return r;
    }

    public Complex[] getStableRoots() {
        return this.m_roots;
    }

    private void roots_at_zero() {
        this.m_idx = 0;
        while (this.m_idx < this.m_p.length && this.m_p[this.m_idx] == 0.0) {
            this.m_roots[this.m_idx++] = Complex.ZERO;
        }
    }

    private void suppress_overflow() {
        boolean loop;
        int nred = this.m_pred.length - 1 - this.m_idx;
        int kiter = 0;
        do {
            loop = false;
            double help = this.x2.abs();
            if (!(help > 1.0) || !(Math.abs((double)nred * Math.log10(help)) > this.MBOUND6)) continue;
            if ((double)(++kiter) < 1000.0) {
                this.h2 = this.h2.times(0.5);
                this.q2 = this.q2.times(0.5);
                this.x2 = this.x2.minus(this.h2);
                loop = true;
                continue;
            }
            kiter = 0;
        } while (loop);
    }

    private void too_big_functionvalues(Ref.DoubleRef f2absq) {
        f2absq.val = Math.abs(((Complex)this.f2.val).getRe()) + Math.abs(((Complex)this.f2.val).getIm()) > this.MBOUND4 ? Math.abs(((Complex)this.f2.val).getRe()) + Math.abs(((Complex)this.f2.val).getIm()) : ((Complex)this.f2.val).absSquare();
    }

    public boolean isLeastSquaresDivision() {
        return this.lqdiv;
    }

    public void setLeastSquaresDivision(boolean lq) {
        this.lqdiv = lq;
    }

    private boolean update(Complex r0) {
        Complex r;
        double nrm = r0.absSquare();
        Complex complex = r = nrm >= 1.0 ? r0 : r0.inv();
        if (!this.lqdiv) {
            this.m_roots[this.m_idx / 2] = r;
            this.m_roots[this.m_idx / 2 + 1] = r.conj();
            this.m_idx += 2;
            double a = -2.0 * r.getRe();
            double b = r.absSquare();
            int n = this.m_degree - 1;
            this.m_pred[n] = this.m_pred[n] - this.m_pred[this.m_degree] * a;
            for (int i = this.m_degree; i > this.m_idx; --i) {
                int n2 = i - 2;
                this.m_pred[n2] = this.m_pred[n2] - (a * this.m_pred[i - 1] + b * this.m_pred[i]);
            }
            this.m_idx += 2;
            Complex ir = r.inv();
            a = -2.0 * ir.getRe();
            b = ir.absSquare();
            int n3 = this.m_degree - 1;
            this.m_pred[n3] = this.m_pred[n3] - this.m_pred[this.m_degree] * a;
            for (int i = this.m_degree; i > this.m_idx; --i) {
                int n4 = i - 2;
                this.m_pred[n4] = this.m_pred[n4] - (a * this.m_pred[i - 1] + b * this.m_pred[i]);
            }
        } else {
            double a = -2.0 * r.getRe();
            double b = r.absSquare();
            Polynomial num = Polynomial.of(this.m_pred, this.m_idx, this.m_degree + 1);
            Polynomial div1 = Polynomial.of(b, a, 1.0);
            Polynomial div2 = Polynomial.of(1.0 / b, a / b, 1.0);
            LeastSquaresDivision lq = new LeastSquaresDivision();
            Polynomial sdiv = div1.times(div2);
            lq.divide(num, sdiv);
            this.m_roots[this.m_idx / 2] = r;
            this.m_roots[this.m_idx / 2 + 1] = r.conj();
            this.m_idx += 4;
            lq.getQuotient().copyTo(this.m_pred, this.m_idx);
        }
        this.reinforceSymmetry();
        return true;
    }

    private boolean update(double r0) {
        double r;
        double d = r = Math.abs(r0) >= 1.0 ? r0 : 1.0 / r0;
        if (Math.abs(r - 1.0) < 1.0E-8) {
            r = 1.0;
        } else if (Math.abs(r + 1.0) < 1.0E-8) {
            r = -1.0;
        }
        double a = -(r + 1.0 / r);
        if (!this.lqdiv) {
            this.m_roots[this.m_idx / 2] = Complex.cart((double)r);
            this.m_idx += 2;
            int n = this.m_degree - 1;
            this.m_pred[n] = this.m_pred[n] - this.m_pred[this.m_degree] * a;
            for (int i = this.m_degree; i > this.m_idx; --i) {
                int n2 = i - 2;
                this.m_pred[n2] = this.m_pred[n2] - (a * this.m_pred[i - 1] + this.m_pred[i]);
            }
        } else {
            Polynomial num = Polynomial.of(this.m_pred, this.m_idx, this.m_degree + 1);
            Polynomial sdiv = Polynomial.of(1.0, a, 1.0);
            LeastSquaresDivision lq = new LeastSquaresDivision();
            lq.divide(num, sdiv);
            this.m_roots[this.m_idx / 2] = Complex.cart((double)r);
            this.m_idx += 2;
            lq.getQuotient().copyTo(this.m_pred, this.m_idx);
        }
        this.reinforceSymmetry();
        return true;
    }

    private void reinforceSymmetry() {
        int n = this.m_degree - this.m_idx;
        for (int i = 0; i < n / 2; ++i) {
            double q;
            this.m_pred[this.m_idx + i] = q = (this.m_pred[this.m_idx + i] + this.m_pred[this.m_degree - i]) / 2.0;
            this.m_pred[this.m_degree - i] = q;
        }
    }

    private static Complex getComplexForIterationCounter(int iter) {
        return COMPLEX_FOR_ITER[iter];
    }

    private static Complex newComplexForIterationCounter(int iter) {
        return Complex.cart((double)Math.cos(iter), (double)Math.sin(iter));
    }

    private static Complex[] initComplexForIter(int maxIter) {
        Complex[] result = new Complex[maxIter + 1];
        for (int i = 0; i < result.length; ++i) {
            result[i] = SymmetricMullerNewtonSolver.newComplexForIterationCounter(i);
        }
        return result;
    }
}

