/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the LICENSE file, which can be found at the root of the source code       *
 * distribution tree, or in https://www.hdfgroup.org/licenses.               *
 * If you do not have access to either file, you may request a copy from     *
 * help@hdfgroup.org.                                                        *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#ifndef H5Bprivate_H
#define H5Bprivate_H

#include "H5private.h"   
#include "H5Fprivate.h"  
#include "H5UCprivate.h" 

typedef enum H5B_subid_t {
    H5B_SNODE_ID = 0, 
    H5B_CHUNK_ID = 1, 
    H5B_NUM_BTREE_ID  
} H5B_subid_t;

typedef enum H5B_ins_t {
    H5B_INS_ERROR  = -1, 
    H5B_INS_NOOP   = 0,  
    H5B_INS_LEFT   = 1,  
    H5B_INS_RIGHT  = 2,  
    H5B_INS_CHANGE = 3,  
    H5B_INS_FIRST  = 4,  
    H5B_INS_REMOVE = 5   
} H5B_ins_t;

typedef enum H5B_dir_t {
    H5B_LEFT  = 0, 
    H5B_RIGHT = 1  
} H5B_dir_t;

typedef int (*H5B_operator_t)(H5F_t *f, const void *_lt_key, haddr_t addr, const void *_rt_key, void *_udata);

typedef struct H5B_shared_t {
    const struct H5B_class_t *type;         
    unsigned                  two_k;        
    size_t                    sizeof_rkey;  
    size_t                    sizeof_rnode; 
    size_t                    sizeof_keys;  
    size_t                    sizeof_addr;  
    size_t                    sizeof_len;   
    uint8_t                  *page;         
    size_t                   *nkey;         
    void                     *udata;        
} H5B_shared_t;

typedef struct H5B_class_t {
    H5B_subid_t id;                                     
    size_t      sizeof_nkey;                            
    H5UC_t *(*get_shared)(const H5F_t *, const void *); 
    herr_t (*new_node)(H5F_t *, H5B_ins_t, void *, void *, void *, haddr_t *);
    int (*cmp2)(void *, void *, void *); 
    int (*cmp3)(void *, void *, void *); 
    htri_t (*found)(H5F_t *, haddr_t, const void *, bool *, void *);

    
    H5B_ins_t (*insert)(H5F_t *, haddr_t, void *, bool *, void *, void *, void *, bool *, haddr_t *);

    
    bool follow_min;
    bool follow_max;

    
    H5B_dir_t critical_key;

    
    H5B_ins_t (*remove)(H5F_t *, haddr_t, void *, bool *, void *, void *, bool *);

    
    herr_t (*decode)(const H5B_shared_t *, const uint8_t *, void *);
    herr_t (*encode)(const H5B_shared_t *, uint8_t *, const void *);
    herr_t (*debug_key)(FILE *, int, int, const void *, const void *);
} H5B_class_t;

typedef struct H5B_info_t {
    hsize_t size;      
    hsize_t num_nodes; 
} H5B_info_t;

H5_DLL herr_t H5B_create(H5F_t *f, const H5B_class_t *type, void *udata, haddr_t *addr_p );
H5_DLL herr_t H5B_find(H5F_t *f, const H5B_class_t *type, haddr_t addr, bool *found, void *udata);
H5_DLL herr_t H5B_insert(H5F_t *f, const H5B_class_t *type, haddr_t addr, void *udata);
H5_DLL herr_t H5B_iterate(H5F_t *f, const H5B_class_t *type, haddr_t addr, H5B_operator_t op, void *udata);
H5_DLL herr_t H5B_get_info(H5F_t *f, const H5B_class_t *type, haddr_t addr, H5B_info_t *bt_info,
                           H5B_operator_t op, void *udata);
H5_DLL herr_t H5B_remove(H5F_t *f, const H5B_class_t *type, haddr_t addr, void *udata);
H5_DLL herr_t H5B_delete(H5F_t *f, const H5B_class_t *type, haddr_t addr, void *udata);
H5_DLL H5B_shared_t *H5B_shared_new(const H5F_t *f, const H5B_class_t *type, size_t sizeof_rkey);
H5_DLL herr_t        H5B_shared_free(void *_shared);
H5_DLL herr_t H5B_debug(H5F_t *f, haddr_t addr, FILE *stream, int indent, int fwidth, const H5B_class_t *type,
                        void *udata);
H5_DLL herr_t H5B_valid(H5F_t *f, const H5B_class_t *type, haddr_t addr);
#endif 
