/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.regarima.estimation;

import java.util.function.ToDoubleFunction;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.core.arima.IArimaModel;
import jdplus.toolkit.base.core.arima.estimation.IArimaMapping;
import jdplus.toolkit.base.core.math.functions.IFunction;
import jdplus.toolkit.base.core.math.functions.IFunctionPoint;
import jdplus.toolkit.base.core.math.functions.IParametersDomain;
import jdplus.toolkit.base.core.math.functions.IParametricMapping;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.regarima.RegArmaModel;
import jdplus.toolkit.base.core.regarima.estimation.ConcentratedLikelihoodComputer;
import jdplus.toolkit.base.core.stats.likelihood.ConcentratedLikelihoodWithMissing;
import jdplus.toolkit.base.core.stats.likelihood.DefaultLikelihoodEvaluation;
import jdplus.toolkit.base.core.stats.likelihood.Likelihood;

public class RegArmaFunction<S extends IArimaModel>
implements IFunction {
    final DoubleSeq dy;
    final FastMatrix x;
    final int nmissing;
    final IParametricMapping<S> mapping;
    final ConcentratedLikelihoodComputer cll;
    final ToDoubleFunction<Likelihood> ll;
    final boolean mt;

    public static <S extends IArimaModel> Builder<S> builder(DoubleSeq y) {
        return new Builder(y);
    }

    private RegArmaFunction(DoubleSeq dy, FastMatrix x, int nm, IArimaMapping<S> mapping, ConcentratedLikelihoodComputer cll, ToDoubleFunction<Likelihood> ll, boolean mt) {
        this.dy = dy;
        this.x = x;
        this.nmissing = nm;
        this.mapping = mapping;
        this.cll = cll;
        this.ll = ll;
        this.mt = mt;
    }

    @Override
    public IParametersDomain getDomain() {
        return this.mapping;
    }

    @Override
    public Evaluation<S> evaluate(DoubleSeq parameters) {
        return new Evaluation(this, parameters);
    }

    public static class Builder<S extends IArimaModel> {
        private ConcentratedLikelihoodComputer cll = ConcentratedLikelihoodComputer.DEFAULT_FULL_COMPUTER;
        private ToDoubleFunction<Likelihood> eval = DefaultLikelihoodEvaluation.deviance();
        private boolean mt = false;
        private final DoubleSeq dy;
        private FastMatrix x;
        private int nmissing;
        private IArimaMapping<S> mapping;

        private Builder(DoubleSeq dy) {
            this.dy = dy;
        }

        public Builder variables(FastMatrix x) {
            this.x = x;
            return this;
        }

        public Builder missingCount(int nm) {
            this.nmissing = nm;
            return this;
        }

        public Builder parallelProcessing(boolean parallel) {
            this.mt = parallel;
            return this;
        }

        public Builder likelihoodComputer(ConcentratedLikelihoodComputer computer) {
            this.cll = computer;
            return this;
        }

        public Builder mapping(IArimaMapping<S> mapping) {
            this.mapping = mapping;
            return this;
        }

        public Builder likelihoodEvaluation(ToDoubleFunction<Likelihood> eval) {
            this.eval = eval;
            return this;
        }

        public RegArmaFunction<S> build() {
            return new RegArmaFunction<S>(this.dy, this.x, this.nmissing, this.mapping, this.cll, this.eval, this.mt);
        }
    }

    public static class Evaluation<S extends IArimaModel>
    implements IFunctionPoint {
        final RegArmaFunction<S> fn;
        final DoubleSeq p;
        final S arma;
        final ConcentratedLikelihoodWithMissing ll;

        public Evaluation(RegArmaFunction<S> fn, DoubleSeq p) {
            this.fn = fn;
            this.p = p;
            this.arma = (IArimaModel)fn.mapping.map(p);
            RegArmaModel<S> regarma = new RegArmaModel<S>(fn.dy, this.arma, fn.nmissing, fn.x);
            this.ll = fn.cll.compute(regarma);
        }

        @Override
        public DoubleSeq getParameters() {
            return this.p;
        }

        @Override
        public double getValue() {
            return this.fn.ll.applyAsDouble(this.ll);
        }

        @Override
        public IFunction getFunction() {
            return this.fn;
        }
    }
}

