/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.math.functions;

import java.util.Arrays;
import java.util.function.DoubleUnaryOperator;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.data.DataBlockIterator;
import jdplus.toolkit.base.core.math.linearsystem.LinearSystemSolver;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import lombok.Generated;
import lombok.NonNull;
import org.jspecify.annotations.Nullable;

public class GenericCubicSpline
implements DoubleUnaryOperator {
    public static final BoundaryConstraints NATURAL = new BoundaryConstraints(Double.NaN, Double.NaN, 0.0);
    public static final BoundaryConstraints STABLE = new BoundaryConstraints(Double.NaN, 0.0, Double.NaN);
    public static final BoundaryConstraints FREE = new BoundaryConstraints(Double.NaN, Double.NaN, Double.NaN);
    final int n;
    final double[] xi;
    final double[] P;

    static void fillConstraints(double[] xi, double[] fxi, FastMatrix C, double[] P, BoundaryConstraints left, BoundaryConstraints right) {
        double dx;
        DataBlock row;
        int k;
        int i;
        double d2f;
        int r = 0;
        int n = xi.length - 1;
        DataBlockIterator rows = C.rowsIterator();
        double df = left.getDf();
        if (Double.isFinite(df)) {
            rows.next().set(1, 1.0);
            P[r++] = df;
        }
        if (Double.isFinite(d2f = left.getD2f())) {
            rows.next().set(2, 1.0);
            P[r++] = d2f;
        }
        for (i = 0; i < n; ++i) {
            k = 4 * i;
            rows.next().set(k, 1.0);
            P[r++] = fxi[i];
            row = rows.next();
            row.set(k, 1.0);
            dx = xi[i + 1] - xi[i];
            row.set(k + 1, dx);
            row.set(k + 2, dx * dx);
            row.set(k + 3, dx * dx * dx);
            P[r++] = fxi[i + 1];
        }
        for (i = 0; i < n - 1; ++i) {
            k = 4 * i;
            row = rows.next();
            dx = xi[i + 1] - xi[i];
            row.set(k + 1, 1.0);
            row.set(k + 2, 2.0 * dx);
            row.set(k + 3, 3.0 * dx * dx);
            row.set(k + 5, -1.0);
            row = rows.next();
            row.set(k + 2, 1.0);
            row.set(k + 3, 3.0 * dx);
            row.set(k + 6, -1.0);
        }
        r += 2 * n - 2;
        df = right.getDf();
        if (Double.isFinite(df)) {
            double dx2 = xi[n] - xi[n - 1];
            double dx22 = dx2 * dx2;
            DataBlock row2 = rows.next();
            int k2 = 4 * (n - 1);
            row2.set(k2 + 1, 1.0);
            row2.set(k2 + 2, 2.0 * dx2);
            row2.set(k2 + 3, 3.0 * dx22);
            P[r++] = df;
        }
        if (Double.isFinite(d2f = right.getD2f())) {
            double dx3 = xi[n] - xi[n - 1];
            DataBlock row3 = rows.next();
            int k3 = 4 * (n - 1);
            row3.set(k3 + 2, 2.0);
            row3.set(k3 + 3, 6.0 * dx3);
            P[r] = d2f;
        }
    }

    private static void fillAggregationConstraints(double[] xi, double[] fi, double fn, FastMatrix C, double[] P, BoundaryConstraints left, BoundaryConstraints right) {
        int k;
        int i;
        double d2f;
        double df;
        int r = 0;
        int n = xi.length - 1;
        DataBlockIterator rows = C.rowsIterator();
        double f = left.getF();
        if (Double.isFinite(f)) {
            rows.next().set(0, 1.0);
            P[r++] = f;
        }
        if (Double.isFinite(df = left.getDf())) {
            rows.next().set(1, 1.0);
            P[r++] = df;
        }
        if (Double.isFinite(d2f = left.getD2f())) {
            rows.next().set(2, 1.0);
            P[r++] = d2f;
        }
        for (i = 0; i < n; ++i) {
            k = 4 * i;
            DataBlock row = rows.next();
            double dx = xi[i + 1] - xi[i];
            row.set(k, dx);
            double dxn = dx * dx;
            row.set(k + 1, dxn / 2.0);
            row.set(k + 2, (dxn *= dx) / 3.0);
            row.set(k + 3, (dxn *= dx) / 4.0);
            P[r++] = fi[i];
        }
        for (i = 0; i < n - 1; ++i) {
            k = 4 * i;
            double dx = xi[i + 1] - xi[i];
            double dx2 = dx * dx;
            double dx3 = dx2 * dx;
            DataBlock row = rows.next();
            row.set(k, 1.0);
            row.set(k + 1, dx);
            row.set(k + 2, dx2);
            row.set(k + 3, dx3);
            row.set(k + 4, -1.0);
            row = rows.next();
            row.set(k + 1, 1.0);
            row.set(k + 2, 2.0 * dx);
            row.set(k + 3, 3.0 * dx2);
            row.set(k + 5, -1.0);
            row = rows.next();
            row.set(k + 2, 1.0);
            row.set(k + 3, 3.0 * dx);
            row.set(k + 6, -1.0);
        }
        r += 3 * n - 3;
        f = right.getF();
        if (Double.isFinite(f)) {
            double dx = xi[n] - xi[n - 1];
            double dx2 = dx * dx;
            double dx3 = dx2 * dx;
            DataBlock row = rows.next();
            int k2 = 4 * (n - 1);
            row.set(k2, 1.0);
            row.set(k2 + 1, dx);
            row.set(k2 + 2, dx2);
            row.set(k2 + 3, dx3);
            P[r++] = f;
        }
        if (Double.isFinite(df = right.getDf())) {
            double dx = xi[n] - xi[n - 1];
            double dx2 = dx * dx;
            DataBlock row = rows.next();
            int k3 = 4 * (n - 1);
            row.set(k3 + 1, 1.0);
            row.set(k3 + 2, 2.0 * dx);
            row.set(k3 + 3, 3.0 * dx2);
            P[r++] = df;
        }
        if (Double.isFinite(d2f = right.getD2f())) {
            double dx = xi[n] - xi[n - 1];
            DataBlock row = rows.next();
            int k4 = 4 * (n - 1);
            row.set(k4 + 2, 2.0);
            row.set(k4 + 3, 6.0 * dx);
            P[r] = d2f;
        }
    }

    public static GenericCubicSpline of(@NonNull double[] xi, @NonNull double[] fxi, BoundaryConstraints left, BoundaryConstraints right) {
        if (xi == null) {
            throw new NullPointerException("xi is marked non-null but is null");
        }
        if (fxi == null) {
            throw new NullPointerException("fxi is marked non-null but is null");
        }
        if (xi.length != fxi.length) {
            throw new IllegalArgumentException("Invalid xi/fxi");
        }
        if (left == null) {
            left = NATURAL;
        }
        if (right == null) {
            right = NATURAL;
        }
        if (left.count(false) + right.count(false) != 2) {
            throw new IllegalArgumentException("Invalid number of constraints");
        }
        int n = xi.length - 1;
        double[] P = new double[4 * n];
        FastMatrix C = FastMatrix.square(P.length);
        GenericCubicSpline.fillConstraints(xi, fxi, C, P, left, right);
        LinearSystemSolver.robustSolver().solve(C, DataBlock.of(P));
        return new GenericCubicSpline(P, xi);
    }

    public static GenericCubicSpline ofAggregation(double[] xi, double[] fxi, BoundaryConstraints left, BoundaryConstraints right) {
        if (xi.length - 1 != fxi.length) {
            throw new IllegalArgumentException("Invalid xi/fxi");
        }
        if (left == null) {
            left = NATURAL;
        }
        if (right == null) {
            right = NATURAL;
        }
        if (left.count(true) + right.count(true) != 3) {
            throw new IllegalArgumentException("Invalid number of constraints");
        }
        int n = xi.length - 1;
        double[] P = new double[4 * n];
        FastMatrix C = FastMatrix.square(P.length);
        double fn = fxi[n - 1] / (xi[n] - xi[n - 1]);
        GenericCubicSpline.fillAggregationConstraints(xi, fxi, fn, C, P, left, right);
        LinearSystemSolver.robustSolver().solve(C, DataBlock.of(P));
        return new GenericCubicSpline(P, xi);
    }

    public DoubleSeq polynomial(int i) {
        return DoubleSeq.of((double[])this.P, (int)(i * 4), (int)4);
    }

    public double x(int i) {
        return this.xi[i];
    }

    public int getPolynomialsCount() {
        return this.n;
    }

    private GenericCubicSpline(double[] P, double[] xi) {
        this.xi = xi;
        this.P = P;
        this.n = xi.length - 1;
    }

    private int find(double x) {
        if (x <= this.xi[0]) {
            return -1;
        }
        if (x >= this.xi[this.n]) {
            return this.n;
        }
        int pos = Arrays.binarySearch(this.xi, x);
        if (pos >= 0) {
            return pos;
        }
        return -pos - 2;
    }

    private double compute(double x, int p) {
        double dx = x - this.xi[p];
        double dx2 = dx * dx;
        double dx3 = dx2 * dx;
        int j = p * 4;
        return this.P[j] + this.P[j + 1] * dx + this.P[j + 2] * dx2 + this.P[j + 3] * dx3;
    }

    private double compute0(double x) {
        double df = this.P[1];
        return this.P[0] + (x - this.xi[0]) * df;
    }

    private double computen(double x) {
        double dx = this.xi[this.n] - this.xi[this.n - 1];
        double dx2 = dx * dx;
        int j = (this.n - 1) * 4;
        double df = this.P[j + 1] + 2.0 * this.P[j + 2] * dx + 3.0 * this.P[j + 3] * dx2;
        double f = this.P[j] + this.P[j + 1] * dx + this.P[j + 2] * dx2 + this.P[j + 3] * dx2 * dx;
        return f + (x - this.xi[this.n]) * df;
    }

    @Override
    public double applyAsDouble(double value) {
        int pos = this.find(value);
        if (pos < 0) {
            return this.compute0(value);
        }
        if (pos >= this.n) {
            return this.computen(value);
        }
        return this.compute(value, pos);
    }

    public static final class BoundaryConstraints {
        private final double f;
        private final double df;
        private final double d2f;

        public int count(boolean level) {
            int n = 0;
            if (level && Double.isFinite(this.f)) {
                ++n;
            }
            if (Double.isFinite(this.df)) {
                ++n;
            }
            if (Double.isFinite(this.d2f)) {
                ++n;
            }
            return n;
        }

        @Generated
        public BoundaryConstraints(double f, double df, double d2f) {
            this.f = f;
            this.df = df;
            this.d2f = d2f;
        }

        @Generated
        public double getF() {
            return this.f;
        }

        @Generated
        public double getDf() {
            return this.df;
        }

        @Generated
        public double getD2f() {
            return this.d2f;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BoundaryConstraints)) {
                return false;
            }
            BoundaryConstraints other = (BoundaryConstraints)o;
            if (Double.compare(this.getF(), other.getF()) != 0) {
                return false;
            }
            if (Double.compare(this.getDf(), other.getDf()) != 0) {
                return false;
            }
            return Double.compare(this.getD2f(), other.getD2f()) == 0;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $f = Double.doubleToLongBits(this.getF());
            result = result * 59 + (int)($f >>> 32 ^ $f);
            long $df = Double.doubleToLongBits(this.getDf());
            result = result * 59 + (int)($df >>> 32 ^ $df);
            long $d2f = Double.doubleToLongBits(this.getD2f());
            result = result * 59 + (int)($d2f >>> 32 ^ $d2f);
            return result;
        }

        @Generated
        public @org.jspecify.annotations.NonNull String toString() {
            return "GenericCubicSpline.BoundaryConstraints(f=" + this.getF() + ", df=" + this.getDf() + ", d2f=" + this.getD2f() + ")";
        }
    }
}

