/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.data.analysis;

import java.util.function.IntToDoubleFunction;
import jdplus.toolkit.base.core.math.Arithmetics;

public enum DiscreteKernel {
    Uniform,
    Triangular,
    Epanechnikov,
    Biweight,
    Triweight,
    Tricube,
    Henderson,
    Trapezoidal;


    public IntToDoubleFunction asFunction(int h) {
        switch (this.ordinal()) {
            case 0: {
                return DiscreteKernel.uniform(h);
            }
            case 1: {
                return DiscreteKernel.triangular(h);
            }
            case 2: {
                return DiscreteKernel.epanechnikov(h);
            }
            case 3: {
                return DiscreteKernel.biweight(h);
            }
            case 4: {
                return DiscreteKernel.triweight(h);
            }
            case 5: {
                return DiscreteKernel.tricube(h);
            }
            case 6: {
                return DiscreteKernel.henderson(h);
            }
            case 7: {
                return DiscreteKernel.trapezoidal(h);
            }
        }
        return null;
    }

    public static IntToDoubleFunction uniform(int h) {
        return i -> 1.0 / (double)(2 * h + 1);
    }

    public static IntToDoubleFunction triangular(int h) {
        double u = 1.0 / (double)(h + 1);
        return i -> (i < 0 ? 1.0 + (double)i * u : 1.0 - (double)i * u) * u;
    }

    public static IntToDoubleFunction triweight(int h) {
        double H = h + 1;
        double H2 = H * H;
        double H4 = H2 * H2;
        double H6 = H2 * H4;
        double q = 1.0 + 2.0 * ((double)h - 3.0 * Arithmetics.sumOfPowers(2, h) / H2 + 3.0 * Arithmetics.sumOfPowers(4, h) / H4 - Arithmetics.sumOfPowers(6, h) / H6);
        return i -> {
            double x = (double)i / H;
            double t = 1.0 - x * x;
            return t * t * t / q;
        };
    }

    public static IntToDoubleFunction biweight(int h) {
        double H = h + 1;
        double H2 = H * H;
        double H4 = H2 * H2;
        double q = 1.0 + 2.0 * ((double)h - 2.0 * Arithmetics.sumOfPowers(2, h) / H2 + Arithmetics.sumOfPowers(4, h) / H4);
        return i -> {
            double x = (double)i / H;
            double t = 1.0 - x * x;
            return t * t / q;
        };
    }

    public static IntToDoubleFunction tricube(int h) {
        double H = h + 1;
        double H3 = H * H * H;
        double H6 = H3 * H3;
        double H9 = H3 * H6;
        double q = 1.0 + 2.0 * ((double)h - 3.0 * Arithmetics.sumOfPowers(3, h) / H3 + 3.0 * Arithmetics.sumOfPowers(6, h) / H6 - Arithmetics.sumOfPowers(9, h) / H9);
        return i -> {
            double x = i >= 0 ? (double)i / H : (double)(-i) / H;
            double t = 1.0 - x * x * x;
            return t * t * t / q;
        };
    }

    public static IntToDoubleFunction epanechnikov(int h) {
        double H = h + 1;
        double H2 = H * H;
        double q = 1.0 + 2.0 * ((double)h - Arithmetics.sumOfPowers(2, h) / H2);
        return i -> {
            double x = (double)i / H;
            return (1.0 - x * x) / q;
        };
    }

    public static IntToDoubleFunction trapezoidal(int h) {
        int len = 2 * h - 1;
        double H = 1.0 / (double)len;
        double H3 = 1.0 / (double)(3 * len);
        return i -> {
            if (i == -h || i == h) {
                return H3;
            }
            if (i == 1 - h || i == h - 1) {
                return 2.0 * H3;
            }
            return H;
        };
    }

    public static IntToDoubleFunction trapezoidal(int lH, int lh) {
        if (lh > lH) {
            throw new IllegalArgumentException();
        }
        int del = 1 + lH - lh;
        int n = 2 * lh + del;
        double H = 1.0 / (double)n;
        double D = H / (double)del;
        return i -> {
            if (i < -lh) {
                return D * (double)(del + lh + i);
            }
            if (i > lh) {
                return D * (double)(del + lh - i);
            }
            return H;
        };
    }

    public static IntToDoubleFunction henderson(int h) {
        double A = h + 1;
        double A2 = A * A;
        double B = h + 2;
        double B2 = B * B;
        double C = h + 3;
        double C2 = C * C;
        double q = A2 * B2 * C2 * (double)(1 + 2 * h) - 2.0 * ((A2 * B2 + A2 * C2 + B2 * C2) * Arithmetics.sumOfPowers(2, h) - (A2 + B2 + C2) * Arithmetics.sumOfPowers(4, h) + Arithmetics.sumOfPowers(6, h));
        return i -> {
            double i2 = i * i;
            return (A2 - i2) * (B2 - i2) * (C2 - i2) / q;
        };
    }

    public static IntToDoubleFunction gaussian(int h, double v) {
        double c = 0.5 / (v * (double)h * (double)h);
        return i -> Math.exp(-c * (double)i * (double)i);
    }

    public double distance(DiscreteKernel other, int horizon) {
        return DiscreteKernel.distance(this.asFunction(horizon), other.asFunction(horizon), horizon);
    }

    public static double distance(IntToDoubleFunction k1, IntToDoubleFunction k2, int horizon) {
        double s = 0.0;
        for (int i = -horizon; i <= horizon; ++i) {
            double d = k1.applyAsDouble(i) - k2.applyAsDouble(i);
            s += d * d;
        }
        return Math.sqrt(s);
    }
}

