
<img src="vignettes/ethnobotanyR.png" alt="ethnobotanyR logo" align="right" width = "25%" height="25%"/>

<!-- README.md is generated from README.Rmd. Please edit that file -->

<!-- badges: start -->

[![CRAN
Status](https://r-pkg.org/badges/version/ethnobotanyR?color=yellow)](https://cran.r-project.org/package=ethnobotanyR)
[![](https://cranlogs.r-pkg.org/badges/grand-total/ethnobotanyR?color=orange)](https://cran.r-project.org/package=ethnobotanyR)
[![](https://cranlogs.r-pkg.org/badges/ethnobotanyR?color=blue)](https://cran.r-project.org/package=ethnobotanyR)
[![](https://cranlogs.r-pkg.org/badges/last-week/ethnobotanyR?color=green)](https://cran.r-project.org/package=ethnobotanyR)
<!-- badges: end -->

[![“Buy Me A
Coffee”](https://buymeacoffee.com/assets/img/custom_images/orange_img.png)](https://buymeacoffee.com/cwhitney)

# ethnobotanyR

Please remember to cite the `ethnobotanyR` package if you use it in your
publications. Use `citation("ethnobotanyR")` to get a citation for the
latest version.

    To cite package 'ethnobotanyR' in publications use:

      Whitney C (2026). _ethnobotanyR: Ethnobotanical Analysis,
      Decision-Framing, and TEK Modeling_. R package version 0.2.0,
      <https://CRAN.R-project.org/package=ethnobotanyR>.

    A BibTeX entry for LaTeX users is

      @Manual{,
        title = {ethnobotanyR: Ethnobotanical Analysis, Decision-Framing, and TEK Modeling},
        author = {Cory Whitney},
        year = {2026},
        note = {R package version 0.2.0},
        url = {https://CRAN.R-project.org/package=ethnobotanyR},
      }

The goal of `ethnobotanyR` is to provide an easy-to-use platform for
ethnobotanists to work with quantitative ethnobotany assessments. It
closely follows [Tardio and Pardo-de-Santayana
(2008)](https://doi.org/10.1007/s12231-007-9004-5) and [Whitney et
al. (2018)](https://doi.org/10.14237/ebl.9.2.2018.503).

Users of `ethnobotanyR` may find it useful to read the background papers
and books on ethnobotany theory. In particular [Albuquerque et
al. (2019)](https://doi.org/10.1007/s13752-019-00316-8) offer helpful
guidance to understanding theoretical approaches in ethnobotany and
developing meaningful research questions.

<!-- Links: start -->

| Quick Links |
|:---|
| [**Installing ethnobotanyR**](https://github.com/CWWhitney/ethnobotanyR#Installation) |
| [**ethnobotanyR CRAN Version**](https://cran.r-project.org/package=ethnobotanyR) |
| [**Quantitative ethnobotany analysis with ethnobotanyR**](http://htmlpreview.github.io/?https://github.com/CWWhitney/ethnobotanyR/blob/master/vignettes/ethnobotanyr_vignette.html) |
| [**Modeling with ethnobotanyR**](https://htmlpreview.github.io/?https://github.com/CWWhitney/ethnobotanyR/blob/master/vignettes/ethnobotanyR_modeling_vignette.html) |
| [**ethnobotanyR Wiki**](https://github.com/CWWhitney/ethnobotanyR/wiki) |

<!-- Links: end -->

## Installation

Install the released version of ethnobotanyR from
[CRAN](https://CRAN.R-project.org) with
`install.packages("ethnobotanyR")`.

Install the working version of ethnobotanyR from
[GitHub](https://github.com) with
`devtools::install_github("CWWhitney/ethnobotanyR")`.

## References

Albuquerque, Ulysses Paulino, Patricia Muniz de Medeiros, Washington
Soares Ferreira Junior, Taline Cristina da Silva, Rafael Ricardo
Vasconcelos da Silva, and Thiago Goncalves-Souza. 2019.
Social-Ecological Theory of Maximization: Basic Concepts and Two Initial
Models. Biological Theory.
[doi.org/10.1007/s13752-019-00316-8](https://doi.org/10.1007/s13752-019-00316-8).

Tardio, J., and M. Pardo-de-Santayana, 2008. Cultural Importance
Indices: A Comparative Analysis Based on the Useful Wild Plants of
Southern Cantabria (Northern Spain) 1. Economic Botany, 62(1), 24-39.
[doi.org/10.1007/s12231-007-9004-5](https://doi.org/10.1007/s12231-007-9004-5).

Whitney, C. W., Bahati, J., and Gebauer, J. (2018), Ethnobotany and
agrobiodiversity; valuation of plants in the homegardens of southwestern
Uganda. Ethnobiology Letters, 9(2), 90-100.
[doi.org/10.14237/ebl.9.2.2018.503](https://doi.org/10.14237/ebl.9.2.2018.503).

Whitney C (2022). *ethnobotanyR: Calculate Quantitative Ethnobotany
Indices*. R package version 0.1.9,
<https://CRAN.R-project.org/package=ethnobotanyR>.
