/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.stats.likelihood;

import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.eco.EcoException;
import jdplus.toolkit.base.api.math.Constants;
import jdplus.toolkit.base.core.stats.likelihood.InternalLikelihood;

public interface Likelihood {
    public static Builder builder(int n) {
        return new Builder(n);
    }

    default public double AIC(int nparams) {
        return -2.0 * this.logLikelihood() + (double)(2 * nparams);
    }

    default public double BIC(int nparams) {
        return -2.0 * this.logLikelihood() + (double)nparams * Math.log(this.dim());
    }

    default public double logLikelihood() {
        int n = this.dim();
        if (this.isScalingFactor()) {
            return -0.5 * ((double)n * Constants.LOGTWOPI + (double)n * (1.0 + Math.log(this.ssq() / (double)n)) + this.logDeterminant());
        }
        return -0.5 * ((double)n * Constants.LOGTWOPI + this.ssq() + this.logDeterminant());
    }

    public int dim();

    public double logDeterminant();

    default public boolean isScalingFactor() {
        return true;
    }

    default public double ser() {
        return this.isScalingFactor() ? Math.sqrt(this.ssq() / (double)this.dim()) : 1.0;
    }

    default public double sigma2() {
        return this.isScalingFactor() ? this.ssq() / (double)this.dim() : 1.0;
    }

    public double ssq();

    public DoubleSeq e();

    default public double factor() {
        if (!this.isScalingFactor()) {
            throw new EcoException("Unexpected operation");
        }
        return Math.exp(this.logDeterminant() / (double)this.dim());
    }

    default public DoubleSeq deviances() {
        double f = this.factor();
        DoubleSeq e = this.e().select(x -> Double.isFinite(x));
        if (f == 1.0) {
            return e;
        }
        double sf = Math.sqrt(f);
        return e.map(x -> x * sf);
    }

    public static class Builder {
        private final int n;
        private double ssqerr;
        private double ldet;
        private double[] res;
        private boolean scalingFactor = true;

        private Builder(int n) {
            this.n = n;
        }

        public Builder scalingFactor(boolean scalingFactor) {
            this.scalingFactor = scalingFactor;
            return this;
        }

        public Builder logDeterminant(double ldet) {
            this.ldet = ldet;
            return this;
        }

        public Builder ssqErr(double ssq) {
            this.ssqerr = ssq;
            return this;
        }

        public Builder residuals(DoubleSeq residuals) {
            if (residuals == null) {
                return this;
            }
            this.res = residuals.toArray();
            return this;
        }

        public Likelihood build() {
            return new InternalLikelihood(this.n, this.ssqerr, this.ldet, this.res, this.scalingFactor);
        }
    }
}

