/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.ssf.dk;

import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.ssf.DataBlockResults;
import jdplus.toolkit.base.core.ssf.DataResults;
import jdplus.toolkit.base.core.ssf.ISsfInitialization;
import jdplus.toolkit.base.core.ssf.StateInfo;
import jdplus.toolkit.base.core.ssf.dk.DiffuseState;
import jdplus.toolkit.base.core.ssf.dk.DiffuseUpdateInformation;
import jdplus.toolkit.base.core.ssf.dk.IDiffuseFilteringResults;
import jdplus.toolkit.base.core.ssf.univariate.DefaultFilteringResults;
import jdplus.toolkit.base.core.ssf.univariate.ISsf;
import jdplus.toolkit.base.core.stats.likelihood.DeterminantalTerm;

public class BaseDiffuseFilteringResults
extends DefaultFilteringResults
implements IDiffuseFilteringResults {
    private final DataBlockResults Ci = new DataBlockResults();
    private final DataResults fi = new DataResults();
    private int enddiffuse;

    protected BaseDiffuseFilteringResults(boolean var) {
        super(var);
    }

    @Override
    public void prepare(ISsf ssf, int start, int end) {
        super.prepare(ssf, start, end);
        ISsfInitialization initialization = ssf.initialization();
        int dim = initialization.getStateDim();
        int n = initialization.getDiffuseDim();
        this.fi.prepare(start, n);
        this.Ci.prepare(dim, start, n);
    }

    @Override
    public void save(int t, DiffuseUpdateInformation pe) {
        super.save(t, pe);
        this.fi.save(t, pe.getDiffuseVariance());
        this.Ci.save(t, pe.Mi());
    }

    @Override
    public void close(int pos) {
        this.enddiffuse = pos;
    }

    @Override
    public void save(int t, DiffuseState state, StateInfo info) {
        if (info != StateInfo.Forecast) {
            return;
        }
        super.save(t, state, info);
    }

    @Override
    public DoubleSeq errors(boolean normalized, boolean clean) {
        DataBlock r = DataBlock.of(this.errors());
        r.range(0, this.enddiffuse).apply(this.fi.extract(0, this.enddiffuse), (x, y) -> y != 0.0 ? Double.NaN : x);
        if (normalized) {
            DoubleSeq allf = this.errorVariances();
            r.apply(allf, (x, y) -> Double.isFinite(x) && Double.isFinite(y) ? x / Math.sqrt(y) : Double.NaN);
        }
        if (clean) {
            r = DataBlock.select((DoubleSeq)r, x -> Double.isFinite(x));
        }
        return r;
    }

    public double diffuseNorm2(int pos) {
        return this.fi.get(pos);
    }

    public DataBlock Mi(int pos) {
        return this.Ci.datablock(pos);
    }

    @Override
    public void clear() {
        super.clear();
        this.Ci.clear();
        this.fi.clear();
        this.enddiffuse = 0;
    }

    @Override
    public int getEndDiffusePosition() {
        return this.enddiffuse;
    }

    @Override
    public double var() {
        int m = 0;
        double ssq = 0.0;
        int nd = this.getEndDiffusePosition();
        for (int i = 0; i < nd; ++i) {
            double e = this.error(i);
            if (!Double.isFinite(e) || this.diffuseNorm2(i) != 0.0) continue;
            ++m;
            ssq += e * e / this.errorVariance(i);
        }
        int n = this.size();
        for (int i = nd; i < n; ++i) {
            double e = this.error(i);
            if (!Double.isFinite(e)) continue;
            ++m;
            ssq += e * e / this.errorVariance(i);
        }
        return ssq / (double)m;
    }

    @Override
    public double logDeterminant() {
        DeterminantalTerm det = new DeterminantalTerm();
        for (int i = 0; i < this.getEndDiffusePosition(); ++i) {
            double e;
            double d;
            if (!Double.isFinite(this.error(i)) || (d = this.diffuseNorm2(i)) != 0.0 || !((e = this.errorVariance(i)) > 1.0E-9)) continue;
            det.add(e);
        }
        int n = this.size();
        for (int i = this.getEndDiffusePosition(); i < n; ++i) {
            double e;
            if (!Double.isFinite(this.error(i)) || !((e = this.errorVariance(i)) > 1.0E-9)) continue;
            det.add(e);
        }
        return det.getLogDeterminant();
    }
}

