/*
 * Decompiled with CFR 0.152.
 */
package internal.toolkit.base.api.timeseries.util;

import internal.toolkit.base.api.timeseries.util.ByLongObsList;
import internal.toolkit.base.api.timeseries.util.NoOpDataBuilder;
import internal.toolkit.base.api.timeseries.util.ObsList;
import internal.toolkit.base.api.timeseries.util.TsDataBuilderUtil;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Calendar;
import java.util.Date;
import java.util.function.Function;
import java.util.function.ToLongFunction;
import jdplus.toolkit.base.api.timeseries.TsData;
import jdplus.toolkit.base.api.timeseries.TsPeriod;
import jdplus.toolkit.base.api.timeseries.TsUnit;
import jdplus.toolkit.base.api.timeseries.util.ObsCharacteristics;
import jdplus.toolkit.base.api.timeseries.util.ObsGathering;
import jdplus.toolkit.base.api.timeseries.util.TsDataBuilder;
import lombok.Generated;

public final class ByLongDataBuilder<T>
implements TsDataBuilder<T> {
    private final ByLongObsList obsList;
    private final ToLongFunction<T> toLong;
    private final boolean skipMissingValues;
    private final Function<ObsList, TsData> maker;

    public static TsDataBuilder<Date> fromCalendar(Calendar resource, ObsGathering gathering, ObsCharacteristics[] characteristics) {
        return TsDataBuilderUtil.isValid(gathering) ? ByLongDataBuilder.of(gathering, characteristics, new CalendarConverter(resource.getTimeZone().toZoneId())) : new NoOpDataBuilder<Date>(TsDataBuilderUtil.INVALID_AGGREGATION);
    }

    public static TsDataBuilder<LocalDate> fromDate(ObsGathering gathering, ObsCharacteristics[] characteristics) {
        return TsDataBuilderUtil.isValid(gathering) ? ByLongDataBuilder.of(gathering, characteristics, DateConverter.INSTANCE) : new NoOpDataBuilder(TsDataBuilderUtil.INVALID_AGGREGATION);
    }

    @Override
    public TsDataBuilder<T> clear() {
        this.obsList.clear();
        return this;
    }

    @Override
    public TsDataBuilder<T> add(T date, Number value) {
        if (date != null) {
            if (value != null) {
                this.obsList.add(this.toLong.applyAsLong(date), value.doubleValue());
            } else if (!this.skipMissingValues) {
                this.obsList.add(this.toLong.applyAsLong(date), Double.NaN);
            }
        }
        return this;
    }

    @Override
    public TsData build() {
        return this.maker.apply(this.obsList);
    }

    private static <T> ByLongDataBuilder<T> of(ObsGathering gathering, ObsCharacteristics[] characteristics, Converter<T> converter) {
        return new ByLongDataBuilder<Object>(ByLongDataBuilder.getLongObsList(TsDataBuilderUtil.isOrdered(characteristics), converter::longToPeriodId), converter::valueToLong, !gathering.isIncludeMissingValues(), TsDataBuilderUtil.getMaker(gathering));
    }

    private static ByLongObsList getLongObsList(boolean preSorted, ByLongObsList.ToPeriodIdFunc tsPeriodIdFunc) {
        return preSorted ? new ByLongObsList.PreSorted(tsPeriodIdFunc, 32) : new ByLongObsList.Sortable(tsPeriodIdFunc);
    }

    @Generated
    private ByLongDataBuilder(ByLongObsList obsList, ToLongFunction<T> toLong, boolean skipMissingValues, Function<ObsList, TsData> maker) {
        this.obsList = obsList;
        this.toLong = toLong;
        this.skipMissingValues = skipMissingValues;
        this.maker = maker;
    }

    private static final class CalendarConverter
    implements Converter<Date> {
        private final ZoneId zoneId;

        @Override
        public long valueToLong(Date value) {
            return value.getTime();
        }

        @Override
        public int longToPeriodId(TsUnit unit, LocalDateTime reference, long l) {
            return (int)TsPeriod.idAt(reference, unit, this.toLocalDateTime(l));
        }

        private LocalDateTime toLocalDateTime(long l) {
            return LocalDateTime.ofInstant(Instant.ofEpochMilli(l), this.zoneId);
        }

        @Generated
        public CalendarConverter(ZoneId zoneId) {
            this.zoneId = zoneId;
        }
    }

    private static interface Converter<T> {
        public long valueToLong(T var1);

        public int longToPeriodId(TsUnit var1, LocalDateTime var2, long var3);
    }

    private static enum DateConverter implements Converter<LocalDate>
    {
        INSTANCE;


        @Override
        public long valueToLong(LocalDate date) {
            return (long)(date.getYear() * 100 + date.getMonthValue()) * 100L + (long)date.getDayOfMonth();
        }

        @Override
        public int longToPeriodId(TsUnit unit, LocalDateTime reference, long l) {
            return (int)TsPeriod.idAt(reference, unit, DateConverter.toLocalDateTime(l));
        }

        private static LocalDateTime toLocalDateTime(long value) {
            int dayOfMonth = (int)value % 100;
            int month = (int)(value /= 100L) % 100;
            return LocalDateTime.of((int)(value /= 100L), month, dayOfMonth, 0, 0);
        }
    }
}

