/*
 * Decompiled with CFR 0.152.
 */
package jdplus.sa.base.core.diagnostics;

import jdplus.sa.base.core.diagnostics.ResidualTradingDaysTestsOptions;
import jdplus.toolkit.base.api.stats.StatisticalTest;
import jdplus.toolkit.base.api.timeseries.TsData;
import jdplus.toolkit.base.core.modelling.regular.tests.TradingDaysTest;
import lombok.Generated;
import org.jspecify.annotations.NonNull;

public class ResidualTradingDaysTests {
    private final TsData sa;
    private final TsData irr;
    private final TsData residuals;
    private final ResidualTradingDaysTestsOptions options;
    private volatile StatisticalTest saTest;
    private volatile StatisticalTest irrTest;
    private volatile StatisticalTest residualsTest;
    private volatile StatisticalTest saLastTest;
    private volatile StatisticalTest irrLastTest;
    private volatile StatisticalTest residualsLastTest;

    private ResidualTradingDaysTests(TsData sa, TsData irr, TsData residuals, ResidualTradingDaysTestsOptions options) {
        this.sa = sa;
        this.irr = irr;
        this.residuals = residuals;
        this.options = options;
    }

    public int annualFrequency() {
        return this.sa.getAnnualFrequency();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StatisticalTest saTest(boolean last) {
        if (last && this.options.getFlast() > 0) {
            StatisticalTest test = this.saLastTest;
            if (test == null) {
                ResidualTradingDaysTests residualTradingDaysTests = this;
                synchronized (residualTradingDaysTests) {
                    test = this.saLastTest;
                    if (test == null) {
                        this.saLastTest = test = this.td2(this.sa, this.options.getFlast(), false);
                    }
                }
            }
            return test;
        }
        StatisticalTest test = this.saTest;
        if (test == null) {
            ResidualTradingDaysTests residualTradingDaysTests = this;
            synchronized (residualTradingDaysTests) {
                test = this.saTest;
                if (test == null) {
                    this.saTest = test = this.td2(this.sa, 0, false);
                }
            }
        }
        return test;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StatisticalTest irrTest(boolean last) {
        if (last && this.options.getFlast() > 0) {
            StatisticalTest test = this.irrLastTest;
            if (test == null) {
                ResidualTradingDaysTests residualTradingDaysTests = this;
                synchronized (residualTradingDaysTests) {
                    test = this.irrLastTest;
                    if (test == null) {
                        this.irrLastTest = test = this.td2(this.irr, this.options.getFlast(), false);
                    }
                }
            }
            return test;
        }
        StatisticalTest test = this.irrTest;
        if (test == null) {
            ResidualTradingDaysTests residualTradingDaysTests = this;
            synchronized (residualTradingDaysTests) {
                test = this.irrTest;
                if (test == null) {
                    this.irrTest = test = this.td2(this.irr, 0, false);
                }
            }
        }
        return test;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StatisticalTest residualsTest(boolean last) {
        if (this.residuals == null) {
            return null;
        }
        if (last && this.options.getFlast() > 0) {
            StatisticalTest test = this.residualsLastTest;
            if (test == null) {
                ResidualTradingDaysTests residualTradingDaysTests = this;
                synchronized (residualTradingDaysTests) {
                    test = this.residualsLastTest;
                    if (test == null) {
                        this.residualsLastTest = test = this.td(this.residuals, this.options.getFlast(), 0);
                    }
                }
            }
            return test;
        }
        StatisticalTest test = this.residualsTest;
        if (test == null) {
            ResidualTradingDaysTests residualTradingDaysTests = this;
            synchronized (residualTradingDaysTests) {
                test = this.residualsTest;
                if (test == null) {
                    this.residualsTest = test = this.td(this.residuals, 0, 0);
                }
            }
        }
        return test;
    }

    private StatisticalTest td(TsData s, int ny, int lag) {
        int ifreq = this.annualFrequency();
        if (ny > 0) {
            s = s.drop(Math.max(0, s.length() - ifreq * ny), 0);
        }
        return TradingDaysTest.olsTest((TsData)s, (int[])new int[]{lag});
    }

    private StatisticalTest td2(TsData s, int ny, boolean seas) {
        int ifreq = this.annualFrequency();
        if (ny > 0) {
            s = s.drop(Math.max(0, s.length() - ifreq * ny), 0);
        }
        return TradingDaysTest.maTest((TsData)s, (boolean)seas);
    }

    @Generated
    public static @NonNull Builder builder() {
        return new Builder();
    }

    @Generated
    public TsData getSa() {
        return this.sa;
    }

    @Generated
    public TsData getIrr() {
        return this.irr;
    }

    @Generated
    public TsData getResiduals() {
        return this.residuals;
    }

    @Generated
    public ResidualTradingDaysTestsOptions getOptions() {
        return this.options;
    }

    @Generated
    private StatisticalTest getSaTest() {
        return this.saTest;
    }

    @Generated
    private StatisticalTest getIrrTest() {
        return this.irrTest;
    }

    @Generated
    private StatisticalTest getResidualsTest() {
        return this.residualsTest;
    }

    @Generated
    private StatisticalTest getSaLastTest() {
        return this.saLastTest;
    }

    @Generated
    private StatisticalTest getIrrLastTest() {
        return this.irrLastTest;
    }

    @Generated
    private StatisticalTest getResidualsLastTest() {
        return this.residualsLastTest;
    }

    @Generated
    public static class Builder {
        @Generated
        private TsData sa;
        @Generated
        private TsData irr;
        @Generated
        private TsData residuals;
        @Generated
        private ResidualTradingDaysTestsOptions options;

        @Generated
        Builder() {
        }

        @Generated
        public @NonNull Builder sa(TsData sa) {
            this.sa = sa;
            return this;
        }

        @Generated
        public @NonNull Builder irr(TsData irr) {
            this.irr = irr;
            return this;
        }

        @Generated
        public @NonNull Builder residuals(TsData residuals) {
            this.residuals = residuals;
            return this;
        }

        @Generated
        public @NonNull Builder options(ResidualTradingDaysTestsOptions options) {
            this.options = options;
            return this;
        }

        @Generated
        public @NonNull ResidualTradingDaysTests build() {
            return new ResidualTradingDaysTests(this.sa, this.irr, this.residuals, this.options);
        }

        @Generated
        public @NonNull String toString() {
            return "ResidualTradingDaysTests.Builder(sa=" + String.valueOf(this.sa) + ", irr=" + String.valueOf(this.irr) + ", residuals=" + String.valueOf(this.residuals) + ", options=" + String.valueOf(this.options) + ")";
        }
    }
}

