/*
 * Decompiled with CFR 0.152.
 */
package jdplus.sa.base.protobuf;

import jdplus.sa.base.api.ComponentType;
import jdplus.sa.base.api.EstimationPolicyType;
import jdplus.sa.base.api.SeriesDecomposition;
import jdplus.sa.base.api.StationaryVarianceDecomposition;
import jdplus.sa.base.api.benchmarking.SaBenchmarkingSpec;
import jdplus.sa.base.api.diagnostics.CombinedSeasonalityTest;
import jdplus.sa.base.core.diagnostics.GenericSaTests;
import jdplus.sa.base.core.tests.CombinedSeasonality;
import jdplus.sa.base.protobuf.SaProtos;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.data.Iterables;
import jdplus.toolkit.base.api.modelling.ComponentInformation;
import jdplus.toolkit.base.api.stats.OneWayAnova;
import jdplus.toolkit.base.api.stats.StatisticalTest;
import jdplus.toolkit.base.api.timeseries.TsData;
import jdplus.toolkit.base.api.timeseries.TsPeriod;
import jdplus.toolkit.base.protobuf.modelling.ModellingProtos;
import jdplus.toolkit.base.protobuf.toolkit.ToolkitProtosUtility;
import lombok.Generated;

public final class SaProtosUtility {
    public static SaBenchmarkingSpec.Target convert(SaProtos.BenchmarkingTarget t) {
        switch (t) {
            case BENCH_TARGET_ORIGINAL: {
                return SaBenchmarkingSpec.Target.Original;
            }
        }
        return SaBenchmarkingSpec.Target.CalendarAdjusted;
    }

    public static SaProtos.BenchmarkingTarget convert(SaBenchmarkingSpec.Target t) {
        switch (t) {
            case Original: {
                return SaProtos.BenchmarkingTarget.BENCH_TARGET_ORIGINAL;
            }
            case CalendarAdjusted: {
                return SaProtos.BenchmarkingTarget.BENCH_TARGET_CALENDARADJUSTED;
            }
        }
        return SaProtos.BenchmarkingTarget.UNRECOGNIZED;
    }

    public static SaProtos.BenchmarkingBias convert(SaBenchmarkingSpec.BiasCorrection t) {
        switch (t) {
            case None: {
                return SaProtos.BenchmarkingBias.BENCH_BIAS_NONE;
            }
            case Additive: {
                return SaProtos.BenchmarkingBias.BENCH_BIAS_ADDITIVE;
            }
            case Multiplicative: {
                return SaProtos.BenchmarkingBias.BENCH_BIAS_MULTIPLICATIVE;
            }
        }
        return SaProtos.BenchmarkingBias.UNRECOGNIZED;
    }

    public static SaBenchmarkingSpec.BiasCorrection convert(SaProtos.BenchmarkingBias t) {
        switch (t) {
            case BENCH_BIAS_ADDITIVE: {
                return SaBenchmarkingSpec.BiasCorrection.Additive;
            }
            case BENCH_BIAS_MULTIPLICATIVE: {
                return SaBenchmarkingSpec.BiasCorrection.Multiplicative;
            }
        }
        return SaBenchmarkingSpec.BiasCorrection.None;
    }

    public static SaBenchmarkingSpec convert(SaProtos.BenchmarkingSpec spec) {
        return (SaBenchmarkingSpec)SaBenchmarkingSpec.builder().enabled(spec.getEnabled()).target(SaProtosUtility.convert(spec.getTarget())).lambda(spec.getLambda()).rho(spec.getRho()).biasCorrection(SaProtosUtility.convert(spec.getBias())).forecast(spec.getForecast()).build();
    }

    public static void fill(SaBenchmarkingSpec spec, SaProtos.BenchmarkingSpec.Builder builder) {
        builder.setEnabled(spec.isEnabled()).setTarget(SaProtosUtility.convert(spec.getTarget())).setLambda(spec.getLambda()).setRho(spec.getRho()).setBias(SaProtosUtility.convert(spec.getBiasCorrection())).setForecast(spec.isForecast());
    }

    public static SaProtos.BenchmarkingSpec convert(SaBenchmarkingSpec spec) {
        SaProtos.BenchmarkingSpec.Builder builder = SaProtos.BenchmarkingSpec.newBuilder();
        SaProtosUtility.fill(spec, builder);
        return builder.build();
    }

    public static SaProtos.SaDecomposition convert(SeriesDecomposition decomp) {
        SaProtos.SaDecomposition.Builder builder = SaProtos.SaDecomposition.newBuilder();
        return builder.setSeries(SaProtosUtility.convert(decomp, ComponentType.Series)).setSeasonallyAdjusted(SaProtosUtility.convert(decomp, ComponentType.SeasonallyAdjusted)).setTrend(SaProtosUtility.convert(decomp, ComponentType.Trend)).setSeasonal(SaProtosUtility.convert(decomp, ComponentType.Seasonal)).setIrregular(SaProtosUtility.convert(decomp, ComponentType.Irregular)).build();
    }

    public static ModellingProtos.TsComponent convert(SeriesDecomposition decomp, ComponentType type) {
        TsData s = decomp.getSeries(type, ComponentInformation.Value);
        TsData fs = decomp.getSeries(type, ComponentInformation.Forecast);
        TsData bs = decomp.getSeries(type, ComponentInformation.Backcast);
        TsData es = decomp.getSeries(type, ComponentInformation.Stdev);
        TsData efs = decomp.getSeries(type, ComponentInformation.StdevForecast);
        TsData ebs = decomp.getSeries(type, ComponentInformation.StdevBackcast);
        if (es == null && s != null) {
            es = TsData.of((TsPeriod)s.getStart(), (DoubleSeq)DoubleSeq.onMapping((int)s.length(), i -> 0.0));
        }
        TsData S = TsData.concatenate((TsData[])new TsData[]{bs, s, fs});
        TsData ES = TsData.concatenate((TsData[])new TsData[]{ebs, es, efs});
        ModellingProtos.TsComponent.Builder builder = ModellingProtos.TsComponent.newBuilder().setData(ToolkitProtosUtility.convert((TsData)S)).setNbcasts(bs == null ? 0 : bs.length()).setNfcasts(fs == null ? 0 : fs.length());
        if (ES != null) {
            builder.addAllStde(Iterables.of((DoubleSeq)ES.getValues()));
        }
        return builder.build();
    }

    public static SaProtos.ComponentType convert(ComponentType type) {
        switch (type) {
            case Series: {
                return SaProtos.ComponentType.SERIES;
            }
            case SeasonallyAdjusted: {
                return SaProtos.ComponentType.SEASONALLYADJUSTED;
            }
            case Trend: {
                return SaProtos.ComponentType.TREND;
            }
            case Seasonal: {
                return SaProtos.ComponentType.SEASONAL;
            }
            case Irregular: {
                return SaProtos.ComponentType.IRREGULAR;
            }
        }
        return SaProtos.ComponentType.UNDEFINED;
    }

    public static SaProtos.VarianceDecomposition convert(StationaryVarianceDecomposition var) {
        return SaProtos.VarianceDecomposition.newBuilder().setCycle(var.getC()).setSeasonal(var.getS()).setIrregular(var.getI()).setCalendar(var.getCalendar()).setOthers(var.getP()).setTotal(var.total()).build();
    }

    public static SaProtos.Diagnostics of(GenericSaTests tests, StationaryVarianceDecomposition var) {
        return SaProtos.Diagnostics.newBuilder().setSeasonalFtestOnIrregular(ToolkitProtosUtility.convert((StatisticalTest)tests.residualSeasonalityTestsOnIrregular().fTest())).setSeasonalFtestOnSa(ToolkitProtosUtility.convert((StatisticalTest)tests.residualSeasonalityTestsOnSa().fTest())).setSeasonalQtestOnIrregular(ToolkitProtosUtility.convert((StatisticalTest)tests.residualSeasonalityTestsOnIrregular().qsTest())).setSeasonalQtestOnSa(ToolkitProtosUtility.convert((StatisticalTest)tests.residualSeasonalityTestsOnSa().qsTest())).setTdFtestOnIrregular(ToolkitProtosUtility.convert((StatisticalTest)tests.residualTradingDaysTests().irrTest(false))).setTdFtestOnSa(ToolkitProtosUtility.convert((StatisticalTest)tests.residualTradingDaysTests().saTest(false))).setVarianceDecomposition(SaProtosUtility.convert(var)).build();
    }

    public static SaProtos.EstimationPolicy convert(EstimationPolicyType policy) {
        switch (policy) {
            case Complete: {
                return SaProtos.EstimationPolicy.POLICY_COMPLETE;
            }
            case Outliers_StochasticComponent: {
                return SaProtos.EstimationPolicy.POLICY_ARIMA;
            }
            case Outliers: {
                return SaProtos.EstimationPolicy.POLICY_OUTLIERS;
            }
            case LastOutliers: {
                return SaProtos.EstimationPolicy.POLICY_LASTOUTLIERS;
            }
            case FreeParameters: {
                return SaProtos.EstimationPolicy.POLICY_FREE_PARAMETERS;
            }
            case FixedAutoRegressiveParameters: {
                return SaProtos.EstimationPolicy.POLICY_FIXED_AUTOREGRESSIVEPARAMETERS;
            }
            case FixedParameters: {
                return SaProtos.EstimationPolicy.POLICY_FIXED_PARAMETERS;
            }
            case Fixed: {
                return SaProtos.EstimationPolicy.POLICY_FIXED;
            }
            case Current: {
                return SaProtos.EstimationPolicy.POLICY_CURRENT;
            }
        }
        return SaProtos.EstimationPolicy.UNRECOGNIZED;
    }

    public static EstimationPolicyType convert(SaProtos.EstimationPolicy policy) {
        switch (policy) {
            case POLICY_COMPLETE: {
                return EstimationPolicyType.Complete;
            }
            case POLICY_ARIMA: {
                return EstimationPolicyType.Outliers_StochasticComponent;
            }
            case POLICY_OUTLIERS: {
                return EstimationPolicyType.Outliers;
            }
            case POLICY_LASTOUTLIERS: {
                return EstimationPolicyType.LastOutliers;
            }
            case POLICY_FREE_PARAMETERS: {
                return EstimationPolicyType.FreeParameters;
            }
            case POLICY_FIXED_AUTOREGRESSIVEPARAMETERS: {
                return EstimationPolicyType.FixedAutoRegressiveParameters;
            }
            case POLICY_FIXED_PARAMETERS: {
                return EstimationPolicyType.FixedParameters;
            }
            case POLICY_FIXED: {
                return EstimationPolicyType.Fixed;
            }
            case POLICY_CURRENT: {
                return EstimationPolicyType.Current;
            }
        }
        return EstimationPolicyType.None;
    }

    public static SaProtos.IdentifiableSeasonality convert(CombinedSeasonalityTest.IdentifiableSeasonality seas) {
        switch (seas) {
            case None: {
                return SaProtos.IdentifiableSeasonality.SA_NONE;
            }
            case ProbablyNone: {
                return SaProtos.IdentifiableSeasonality.SA_PROBABLY_NONE;
            }
            case Present: {
                return SaProtos.IdentifiableSeasonality.SA_PRESENT;
            }
        }
        return SaProtos.IdentifiableSeasonality.SA_UNKNOWN;
    }

    public static SaProtos.CombinedSeasonalityTest convert(CombinedSeasonality cs) {
        return SaProtos.CombinedSeasonalityTest.newBuilder().setKruskalWallis(ToolkitProtosUtility.convert((StatisticalTest)cs.getNonParametricTestForStableSeasonality().build())).setStableSeasonality(ToolkitProtosUtility.convert((OneWayAnova)cs.getStableSeasonalityTest())).setEvolutiveSeasonality(ToolkitProtosUtility.convert((OneWayAnova)cs.getEvolutiveSeasonalityTest())).setSeasonality(SaProtosUtility.convert(cs.getSummary())).build();
    }

    @Generated
    private SaProtosUtility() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

