/*
 * Decompiled with CFR 0.152.
 */
package usf.saav.common;

import java.util.Vector;

public interface EventTimer {
    public String getName();

    public long getStartTime();

    public long getEndTime();

    public long getElapsedTime();

    public double getElapsedTimeMilliseconds();

    public static class CombinedEvents
    implements EventTimer {
        String name;
        Vector<EventTimer> events = new Vector();

        public CombinedEvents(String string) {
            this.name = string;
        }

        @Override
        public String getName() {
            return this.name;
        }

        public void add(EventTimer eventTimer) {
            this.events.add(eventTimer);
        }

        @Override
        public long getStartTime() {
            long l = Long.MAX_VALUE;
            for (EventTimer eventTimer : this.events) {
                l = Math.min(l, eventTimer.getStartTime());
            }
            return l;
        }

        @Override
        public long getEndTime() {
            long l = 0L;
            for (EventTimer eventTimer : this.events) {
                l = Math.max(l, eventTimer.getEndTime());
            }
            return l;
        }

        @Override
        public long getElapsedTime() {
            long l = 0L;
            for (EventTimer eventTimer : this.events) {
                l += eventTimer.getElapsedTime();
            }
            return l;
        }

        @Override
        public double getElapsedTimeMilliseconds() {
            return (double)this.getElapsedTime() * 1.0E-6;
        }
    }

    public static class Default
    implements EventTimer {
        long proc_start;
        long proc_end;
        String name;

        public Default(String string) {
            this.name = string;
        }

        public void start() {
            this.proc_start = System.nanoTime();
        }

        public void stop() {
            this.proc_end = System.nanoTime();
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public long getStartTime() {
            return this.proc_start;
        }

        @Override
        public long getEndTime() {
            return this.proc_end;
        }

        @Override
        public long getElapsedTime() {
            return this.getEndTime() - this.getStartTime();
        }

        @Override
        public double getElapsedTimeMilliseconds() {
            return (double)this.getElapsedTime() * 1.0E-6;
        }
    }
}

